package com.sinosoftgz.starter.sms.core.api;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.sms.core.request.MultiSmsSendReq;
import com.sinosoftgz.starter.sms.core.request.SmsSendReq;

import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-09 17:25
 * @description: 短信接口
 * 各个业务方实现接口，默认是http协议，后续可以增加RPC等协议，由各个业务系统技术栈决定
 */
public interface SmsSendApi {
    /**
     * 简单的短信发送
     *
     * @param recipientTo 接收人
     * @param content     内容
     * @return 是否发送成功
     */
    public boolean sendSimpleSms(String recipientTo, String content);

    /**
     * 短信发送
     *
     * @param smsSendReq 短信发送请求对象
     * @return 是否发送成功
     */
    public boolean sendSms(BaseRequest<SmsSendReq> smsSendReq);

    /**
     * 批量短信发送（一个手机号对应一个短信内容）
     *
     * @param smsSendReqs
     * @return 是否发送成功
     */
    public boolean batchSendSms(BaseRequest<List<SmsSendReq>> smsSendReqs);

    /**
     * 批量短信发送（多个手机号对应一个短信内容）
     *
     * @param multiSmsSendReq
     * @return 是否发送成功
     */
    public boolean multiSendSms(BaseRequest<MultiSmsSendReq> multiSmsSendReq);
}
