package com.sinosoftgz.starter.sms.core.api.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.sms.core.api.SmsSendApi;
import com.sinosoftgz.starter.sms.core.biz.SmsSendBiz;
import com.sinosoftgz.starter.sms.core.constant.SmsConstants;
import com.sinosoftgz.starter.sms.core.request.MultiSmsSendReq;
import com.sinosoftgz.starter.sms.core.request.SmsSendReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 发送短信 http 协议接口实现
 *
 * @author: Roney
 * @date: 2022-05-09 17:26
 * @description: 发送短信 http 协议接口实现
 */
@RestController
@RequestMapping(SmsConstants.APP_BASE_CONTEXT + "/send")
@Slf4j
public class SmsSendApiRestController {

    @Resource
    SmsSendBiz smsSendBiz;

    /**
     * 简单的短信发送
     *
     * @param recipientTo 接收人
     * @param content     内容
     * @return 是否发送成功
     */
    @PostMapping("/simple")
    public BaseResponse sendSimpleSms(@RequestParam(name = "recipientTo", required = true) String recipientTo, String content) {
        return BaseResponse.ok(smsSendBiz.sendSimpleSms(recipientTo, content));
    }

    /**
     * 短信发送
     *
     * @param smsSendReq 短信发送请求对象
     * @return 是否发送成功
     */

    @PostMapping("")
    public BaseResponse sendSms(BaseRequest<SmsSendReq> smsSendReq) {
        return BaseResponse.ok(smsSendBiz.sendSms(smsSendReq));
    }

    /**
     * 批量短信发送（一个手机号对应一个短信内容）
     *
     * @param smsSendReqs
     * @return 是否发送成功
     */

    @PostMapping("/batch")
    public BaseResponse batchSendSms(BaseRequest<List<SmsSendReq>> smsSendReqs) {
        return BaseResponse.ok(smsSendBiz.batchSendSms(smsSendReqs));
    }

    /**
     * 批量短信发送（多个手机号对应一个短信内容）
     *
     * @param multiSmsSendReq
     * @return
     */
    @PostMapping("/multi")
    public BaseResponse multiSendSms(BaseRequest<MultiSmsSendReq> multiSmsSendReq) {
        return BaseResponse.ok(smsSendBiz.multiSendSms(multiSmsSendReq));
    }
}
