package com.sinosoftgz.starter.sms.core.biz.impl;

import com.google.common.collect.Lists;
import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.sms.core.biz.SmsLogBiz;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import com.sinosoftgz.starter.sms.log.storage.core.biz.SmsLogStorageBiz;
import com.sinosoftgz.starter.sms.log.storage.core.properties.SmsLogStorageProperties;
import com.sinosoftgz.starter.sms.log.storage.core.request.SmsLogStorageReq;
import com.sinosoftgz.starter.utils.date.DateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-16 18:25
 * @description: 日志记录业务逻辑实现
 */
@Component
@ConditionalOnProperty(prefix = SmsLogStorageProperties.SMS_LOG_STORAGE_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class SmsLogBizImpl implements SmsLogBiz {

    @Resource
    SmsLogStorageBiz smsLogStorageBiz;

    @Override
    public void saveSendSmsLog(JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        List<SmsLogStorageReq> smsLogStorageReqs = Lists.newCopyOnWriteArrayList();
        javaSmsClientReq.getRecipientTos().parallelStream().forEach(recipientTo -> {
            SmsLogStorageReq smsLogStorageReq = new SmsLogStorageReq();
            smsLogStorageReq.setRecipientTo(recipientTo);
            smsLogStorageReq.setMessageContent(javaSmsClientReq.getContent());
            smsLogStorageReq.setSendTime(DateUtils.now());
            smsLogStorageReq.setSmsPlatformType(javaSmsClientReq.getSmsPlatformType());
            smsLogStorageReqs.add(smsLogStorageReq);
        });
        smsLogStorageBiz.batchRecordSendSmsLog(BaseRequest.simple(smsLogStorageReqs));
    }

    /**
     * 校验参数信息
     *
     * @param javaSmsClientReq
     */
    public void checkJavaSmsClient(JavaSmsClientReq javaSmsClientReq) {
        Assert.notNull(javaSmsClientReq, "短信发送统一请求对象不能为空");
        Assert.notEmpty(javaSmsClientReq.getRecipientTos(), "接收人列表不能为空");
    }
}
