package com.sinosoftgz.starter.sms.core.config;

import com.sinosoftgz.starter.sms.core.api.impl.SmsSendApiRestController;
import com.sinosoftgz.starter.sms.core.properties.SmsPlatformProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @author: Roney
 * @date: 2022-05-09 17:29
 * @description: CustomerSmsConfiguration
 */

@Configuration
@Import({
        SmsSendApiRestController.class
})
@ComponentScan(basePackages = {"com.sinosoftgz.starter.sms.core.**", "com.sinosoftgz.starter.spring.utils.**"})
@EnableConfigurationProperties(SmsPlatformProperties.class)
public class CustomerSmsConfiguration {

    SmsPlatformProperties smsPlatformProperties;

    public CustomerSmsConfiguration(final SmsPlatformProperties smsPlatformProperties) {
        this.smsPlatformProperties = smsPlatformProperties;
    }
}
