package com.sinosoftgz.starter.sms.core.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author: Roney
 * @date: 2022-05-09 14:16
 * @description: 短信平台
 */
public enum SmsPlatformType {

    MOCK("MOCK", "MOCK"),
    MICROSOFT("MICROSOFT", "微软短信平台"),
    ALIBABA("ALIBABA", "阿里短信平台"),
    TENCENT("TENCENT", "腾讯短信平台"),
    NET_EASE("NET_EASE", "网易短信平台"),
    OTHER("OTHER", "其他短信平台"),
    ;
    public static Map<String, SmsPlatformType> smsPlatformTypeMap = Maps.newConcurrentMap();


    static {
        smsPlatformTypeMap.put(MOCK.getType(), MOCK);
        smsPlatformTypeMap.put(MICROSOFT.getType(), MICROSOFT);
        smsPlatformTypeMap.put(ALIBABA.getType(), ALIBABA);
        smsPlatformTypeMap.put(TENCENT.getType(), TENCENT);
        smsPlatformTypeMap.put(NET_EASE.getType(), NET_EASE);
        smsPlatformTypeMap.put(OTHER.getType(), OTHER);
    }

    /**
     * 类型
     */
    private String type;
    /**
     * 描述
     */
    private String remark;

    SmsPlatformType(String type, String remark) {
        this.type = type;
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
