package com.sinosoftgz.starter.sms.core.handler;


import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import com.sinosoftgz.starter.spring.utils.handler.AbstractHandler;
import org.springframework.util.Assert;

/**
 * @author: Roney
 * @date: 2022-05-09 14:29
 * @description: AbstractMailHandler
 */
public abstract class AbstractSmsHandler extends AbstractHandler implements SmsHandler {

    /**
     * 测试策略模式
     */
    public abstract void testStrategyPattern();

    /**
     * 短信发送
     *
     * @param javaSmsClientReq
     * @return
     */
    @Override
    public abstract boolean send(JavaSmsClientReq javaSmsClientReq);

    /**
     * 短信发送（多个手机号对应一个短信内容）
     * 如果短信机没有提供这种接口，实现类循环遍历手机号，单个发送
     *
     * @param javaSmsClientReq
     * @return
     */
    @Override
    public abstract boolean multiSend(JavaSmsClientReq javaSmsClientReq);

    /**
     * 校验参数信息
     *
     * @param javaSmsClientReq
     */
    public void checkJavaSmsClient(JavaSmsClientReq javaSmsClientReq) {
        Assert.notNull(javaSmsClientReq, "短信发送统一请求对象不能为空");
        Assert.notEmpty(javaSmsClientReq.getRecipientTos(), "接收人列表不能为空");
    }
}
