package com.sinosoftgz.starter.sms.core.handler;


import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import com.sinosoftgz.starter.spring.utils.bean.BeansTools;
import com.sinosoftgz.starter.spring.utils.handler.AbstractHandler;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * @author Roney
 * @date 2021/5/27 14:24
 */
public class SmsHandlerContext {
    private Map<SmsPlatformType, Class> handlerMap;

    public SmsHandlerContext(Map<SmsPlatformType, Class> handlerMap) {
        this.handlerMap = handlerMap;
    }

    public AbstractHandler getInstance(SmsPlatformType type) {
        Class clazz = handlerMap.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException("not found handler for type: " + type);
        }
        String beanName = StringUtils.uncapitalize(clazz.getSimpleName());
        return (AbstractHandler) BeansTools.getBean(beanName, clazz);
    }

}
