package com.sinosoftgz.starter.sms.core.handler;


import com.google.common.collect.Maps;
import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;

import com.sinosoftgz.starter.sms.core.handler.annotation.SmsHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by Roney on 2021/5/27 14:26.
 */
@Component
public class SmsHandlerProcessor implements BeanFactoryPostProcessor {
    /**
     * 指定扫描处理器的包，不做配置化，减少复杂度，只认这个包下的实现类
     */
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.sms.core.handler";

    /**
     * 扫描@HandlerType，初始化HandlerContext，将其注册到spring容器
     *
     * @param beanFactory bean工厂
     * @see SmsPlatformType
     * @see SmsHandlerContext
     */
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map<SmsPlatformType, Class> handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan(HANDLER_PACKAGE, SmsHandlerType.class).forEach(clazz -> {
            SmsPlatformType type = clazz.getAnnotation(SmsHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        SmsHandlerContext context = new SmsHandlerContext(handlerMap);
        beanFactory.registerSingleton(SmsHandlerContext.class.getName(), context);
    }
}
