package com.sinosoftgz.starter.sms.core.handler.biz;

import com.sinosoftgz.starter.sms.core.handler.AbstractSmsHandler;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.Valid;

/**
 * @author: Roney
 * @date: 2022-05-09 18:37
 * @description: DefaultSmsHandler
 */
@Component
@Slf4j
public class DefaultSmsHandler extends AbstractSmsHandler {

    @Override
    public void testStrategyPattern() {
        log.debug("DefaultSmsHandler");
    }

    @Override
    public boolean send(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        return false;
    }

    @Override
    public boolean multiSend(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        return false;
    }
}
