package com.sinosoftgz.starter.sms.core.handler.biz;

import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import com.sinosoftgz.starter.sms.core.handler.AbstractSmsHandler;
import com.sinosoftgz.starter.sms.core.handler.annotation.SmsHandlerType;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.Valid;

/**
 * @author: Roney
 * @date: 2022-05-09 18:37
 * @description: MockSmsHandler
 * Mock实现，业务方不需要在写if判断是否开关打开
 */
@Component
@SmsHandlerType(SmsPlatformType.MOCK)
@Slf4j
public class MockSmsHandler extends DefaultSmsHandler {

    @Override
    public void testStrategyPattern() {
        log.debug("MockSmsHandler");
    }

    @Override
    public boolean send(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        log.info("使用Mock实现，默认发送成功");
        return true;
    }

    @Override
    public boolean multiSend(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        log.info("使用Mock实现，默认发送成功");
        return true;
    }
}
