package com.sinosoftgz.starter.sms.core.properties;

import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author: Roney
 * @date: 2022-05-09 17:36
 * @description: 短信平台配置
 */
@ConfigurationProperties(prefix = SmsPlatformProperties.SMS_PLATFORM_PREFIX)
@Data
public class SmsPlatformProperties {

    public static final String SMS_PLATFORM_PREFIX = "sms.platform";

    /**
     * 短信平台类型，默认是MOCK
     * 没有通用的短信平台，需要由各个业务系统去扩展
     */
    private String type = SmsPlatformType.MOCK.getType();
}
