package com.sinosoftgz.starter.sms.core.request;

import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import lombok.Data;


import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-09 18:10
 * @description: java 短信发送统一请求对象
 */
@Data
public class JavaSmsClientReq implements Serializable {

    /**
     * 短信平台类型
     */
    private String smsPlatformType;

    /**
     * 接收人列表
     */
    @NotEmpty(message = "接收人列表不能为空")
    private List<String> recipientTos;
    /**
     * 短信内容
     */
    private final String content;

    private JavaSmsClientReq(JavaSmsClientReqBuilder builder) {
        this.smsPlatformType = builder.smsPlatformType;
        this.recipientTos = builder.recipientTos;
        this.content = builder.content;
    }

    public static class JavaSmsClientReqBuilder {

        private String smsPlatformType;
        private List<String> recipientTos;
        private String content;


        public JavaSmsClientReqBuilder() {
            this.recipientTos = new ArrayList<>(1);
            this.smsPlatformType = SmsPlatformType.MOCK.getType();
            this.content = "";
        }


        /**
         * @param recipientTos
         * @return
         * @Desc 接收人列表
         */
        public JavaSmsClientReqBuilder recipientTos(List<String> recipientTos) {
            this.recipientTos = recipientTos;
            return this;
        }

        /**
         * @param smsPlatformType
         * @return
         * @Desc 短信平台类型
         */
        public JavaSmsClientReqBuilder smsPlatformType(String smsPlatformType) {
            this.smsPlatformType = smsPlatformType;
            return this;
        }


        /**
         * @param content
         * @return
         * @Desc 短信内容
         */
        public JavaSmsClientReqBuilder content(String content) {
            this.content = content;
            return this;
        }

        /**
         * @return
         * @Desc 创建短信
         */
        public JavaSmsClientReq build() {
            return new JavaSmsClientReq(this);
        }
    }
}
