package com.sinosoftgz.starter.sms.core.request;

import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * Created by roney on 2022/5/11 20:57
 *
 * @description: 多个接收人发送请求对象
 * 业务场景如下：部分短信机支持一次性多个手机号，发送同一份短信内容
 */
@Data
@Builder
public class MultiSmsSendReq implements Serializable {

    /**
     * 接收人列表
     */
    @NotEmpty(message = "接收人列表不能为空")
    private List<String> recipientTos;
    /**
     * 短信内容
     */
    private String content;
}
