package com.sinosoftgz.starter.sms.core.request;

import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: Roney
 * @date: 2022-05-09 17:44
 * @description: 短信发送请求对象
 */
@Data
@Builder
public class SmsSendReq implements Serializable {

    /**
     * 接收人
     */
    @NotBlank(message = "接收人不能为空")
    private String recipientTo;
    /**
     * 短信内容
     */
    private String content;
}
