/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sms.core.aop;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.sms.core.biz.SmsLogBiz;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import javax.annotation.Resource;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@Aspect
@ConditionalOnProperty(prefix="sms.log.storage", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SmsLogStorageAspect {
    private static final Logger log = LoggerFactory.getLogger(SmsLogStorageAspect.class);
    @Resource
    SmsLogBiz smsLogBiz;
    private final String ADD_POINT_CUT = " (execution(* com.sinosoftgz.starter.sms.core.handler..*.*(..))&& args(javaSmsClientReq))";

    @Before(value="saveSendSmsLog(javaSmsClientReq)")
    public void sendSmsLogCall(JavaSmsClientReq javaSmsClientReq) {
        log.debug("send sms log ! javaSmsClientReq:{}", (Object)JSON.toJSONString((Object)javaSmsClientReq));
        try {
            this.smsLogBiz.saveSendSmsLog(javaSmsClientReq);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }

    @Pointcut(value=" (execution(* com.sinosoftgz.starter.sms.core.handler..*.*(..))&& args(javaSmsClientReq))")
    public void saveSendSmsLog(JavaSmsClientReq javaSmsClientReq) {
    }
}

