/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sms.core.api.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.sms.core.biz.SmsSendBiz;
import com.sinosoftgz.starter.sms.core.request.MultiSmsSendReq;
import com.sinosoftgz.starter.sms.core.request.SmsSendReq;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sms/send"})
public class SmsSendApiRestController {
    private static final Logger log = LoggerFactory.getLogger(SmsSendApiRestController.class);
    @Resource
    SmsSendBiz smsSendBiz;

    @PostMapping(value={"/simple"})
    public BaseResponse sendSimpleSms(@RequestParam(name="recipientTo", required=true) String recipientTo, String content) {
        return BaseResponse.ok((Object)this.smsSendBiz.sendSimpleSms(recipientTo, content));
    }

    @PostMapping(value={""})
    public BaseResponse sendSms(BaseRequest<SmsSendReq> smsSendReq) {
        return BaseResponse.ok((Object)this.smsSendBiz.sendSms(smsSendReq));
    }

    @PostMapping(value={"/batch"})
    public BaseResponse batchSendSms(BaseRequest<List<SmsSendReq>> smsSendReqs) {
        return BaseResponse.ok((Object)this.smsSendBiz.batchSendSms(smsSendReqs));
    }

    @PostMapping(value={"/multi"})
    public BaseResponse multiSendSms(BaseRequest<MultiSmsSendReq> multiSmsSendReq) {
        return BaseResponse.ok((Object)this.smsSendBiz.multiSendSms(multiSmsSendReq));
    }
}

