/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sms.core.biz.impl;

import com.google.common.collect.Lists;
import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.sms.core.biz.SmsLogBiz;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import com.sinosoftgz.starter.sms.log.storage.core.biz.SmsLogStorageBiz;
import com.sinosoftgz.starter.sms.log.storage.core.request.SmsLogStorageReq;
import com.sinosoftgz.starter.utils.date.DateUtils;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@ConditionalOnProperty(prefix="sms.log.storage", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SmsLogBizImpl
implements SmsLogBiz {
    @Resource
    SmsLogStorageBiz smsLogStorageBiz;

    @Override
    public void saveSendSmsLog(JavaSmsClientReq javaSmsClientReq) {
        this.checkJavaSmsClient(javaSmsClientReq);
        CopyOnWriteArrayList smsLogStorageReqs = Lists.newCopyOnWriteArrayList();
        javaSmsClientReq.getRecipientTos().parallelStream().forEach(recipientTo -> {
            SmsLogStorageReq smsLogStorageReq = new SmsLogStorageReq();
            smsLogStorageReq.setRecipientTo(recipientTo);
            smsLogStorageReq.setMessageContent(javaSmsClientReq.getContent());
            smsLogStorageReq.setSendTime(DateUtils.now());
            smsLogStorageReq.setSmsPlatformType(javaSmsClientReq.getSmsPlatformType());
            smsLogStorageReqs.add(smsLogStorageReq);
        });
        this.smsLogStorageBiz.batchRecordSendSmsLog(BaseRequest.simple((Object)smsLogStorageReqs));
    }

    public void checkJavaSmsClient(JavaSmsClientReq javaSmsClientReq) {
        Assert.notNull((Object)javaSmsClientReq, (String)"\u77ed\u4fe1\u53d1\u9001\u7edf\u4e00\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(javaSmsClientReq.getRecipientTos(), (String)"\u63a5\u6536\u4eba\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

