/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sms.core.biz.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.sms.core.biz.SmsSendBiz;
import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import com.sinosoftgz.starter.sms.core.handler.AbstractSmsHandler;
import com.sinosoftgz.starter.sms.core.handler.SmsHandlerContext;
import com.sinosoftgz.starter.sms.core.properties.SmsPlatformProperties;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import com.sinosoftgz.starter.sms.core.request.MultiSmsSendReq;
import com.sinosoftgz.starter.sms.core.request.SmsSendReq;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class SmsSendBizImpl
implements SmsSendBiz {
    private static final Logger log = LoggerFactory.getLogger(SmsSendBizImpl.class);
    @Resource
    SmsHandlerContext smsHandlerContext;
    @Autowired
    SmsPlatformProperties smsPlatformProperties;

    @Override
    public boolean sendSimpleSms(String recipientTo, String content) {
        this.checkRecipientTo(recipientTo);
        try {
            AbstractSmsHandler handler = this.getAbstractSmsHandler();
            JavaSmsClientReq javaSmsClientReq = new JavaSmsClientReq.JavaSmsClientReqBuilder().content(content).recipientTos(Arrays.asList(recipientTo)).smsPlatformType(this.getSmsPlatformType().getType()).build();
            return handler.send(javaSmsClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean sendSms(BaseRequest<SmsSendReq> smsSendReq) {
        Assert.notNull(smsSendReq, (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)smsSendReq.getData(), (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)((SmsSendReq)smsSendReq.getData()).getRecipientTo(), (String)"\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            AbstractSmsHandler handler = this.getAbstractSmsHandler();
            SmsSendReq smsSendReqReq = (SmsSendReq)smsSendReq.getData();
            JavaSmsClientReq javaSmsClientReq = new JavaSmsClientReq.JavaSmsClientReqBuilder().content(smsSendReqReq.getContent()).smsPlatformType(this.getSmsPlatformType().getType()).recipientTos(Arrays.asList(smsSendReqReq.getRecipientTo())).build();
            return handler.send(javaSmsClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean batchSendSms(BaseRequest<List<SmsSendReq>> smsSendReqs) {
        Assert.notNull(smsSendReqs, (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)((Collection)smsSendReqs.getData()), (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            List smsSendReqList = (List)smsSendReqs.getData();
            if (!CollectionUtils.isEmpty((Collection)smsSendReqList)) {
                smsSendReqList.parallelStream().forEach(smsSendReq -> this.sendSms((BaseRequest<SmsSendReq>)BaseRequest.simple((Object)smsSendReq)));
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean multiSendSms(BaseRequest<MultiSmsSendReq> multiSmsSendReq) {
        Assert.notNull(multiSmsSendReq, (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)multiSmsSendReq.getData(), (String)"\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(((MultiSmsSendReq)multiSmsSendReq.getData()).getRecipientTos(), (String)"\u63a5\u6536\u4eba\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            AbstractSmsHandler handler = this.getAbstractSmsHandler();
            MultiSmsSendReq multiSmsSendReqReq = (MultiSmsSendReq)multiSmsSendReq.getData();
            JavaSmsClientReq javaSmsClientReq = new JavaSmsClientReq.JavaSmsClientReqBuilder().content(multiSmsSendReqReq.getContent()).smsPlatformType(this.getSmsPlatformType().getType()).recipientTos(multiSmsSendReqReq.getRecipientTos()).build();
            return handler.multiSend(javaSmsClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private void checkRecipientTo(String recipientTo) {
        Assert.notNull((Object)recipientTo, (String)"\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private AbstractSmsHandler getAbstractSmsHandler() {
        return (AbstractSmsHandler)this.smsHandlerContext.getInstance(this.getSmsPlatformType());
    }

    private SmsPlatformType getSmsPlatformType() {
        String type = this.smsPlatformProperties.getType();
        SmsPlatformType smsPlatformType = SmsPlatformType.MOCK;
        if (StringUtils.hasLength((String)type) && !Objects.isNull((Object)SmsPlatformType.smsPlatformTypeMap.get(type))) {
            smsPlatformType = SmsPlatformType.smsPlatformTypeMap.get(type);
        }
        return smsPlatformType;
    }
}

