/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.sms.core.handler;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import com.sinosoftgz.starter.sms.core.handler.SmsHandlerContext;
import com.sinosoftgz.starter.sms.core.handler.annotation.SmsHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class SmsHandlerProcessor
implements BeanFactoryPostProcessor {
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.sms.core.handler";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConcurrentMap handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan((String)HANDLER_PACKAGE, (Class[])new Class[]{SmsHandlerType.class}).forEach(clazz -> {
            SmsPlatformType type = clazz.getAnnotation(SmsHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        SmsHandlerContext context = new SmsHandlerContext(handlerMap);
        beanFactory.registerSingleton(SmsHandlerContext.class.getName(), (Object)context);
    }
}

