package com.sinosoftgz.starter.sms.core.handler.biz;

import com.sinosoftgz.starter.sms.core.enums.SmsPlatformType;
import com.sinosoftgz.starter.sms.core.handler.AbstractSmsHandler;
import com.sinosoftgz.starter.sms.core.handler.annotation.SmsHandlerType;
import com.sinosoftgz.starter.sms.core.request.JavaSmsClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.Valid;

/**
 * @author: Roney
 * @date: 2022-05-09 18:37
 * @description: MicrosoftSmsHandler
 */
@Component
@SmsHandlerType(SmsPlatformType.MICROSOFT)
@Slf4j
public class MicrosoftSmsHandler extends DefaultSmsHandler {

    @Override
    public void testStrategyPattern() {
        log.debug("MicrosoftSmsHandler");
    }

    @Override
    public boolean send(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        /**
         * todo： 增加重复拦截，10秒内，不允许向同一个用户发送相同的短信，服务未连接redis，暂时不做防重
         */
        log.info("微软短信客户端平台实现");
        return true;
    }

    @Override
    public boolean multiSend(@Valid JavaSmsClientReq javaSmsClientReq) {
        checkJavaSmsClient(javaSmsClientReq);
        /**
         * todo： 增加重复拦截，10秒内，不允许向同一个用户发送相同的短信，服务未连接redis，暂时不做防重
         */
        log.info("微软短信客户端平台实现");
        return true;
    }
}
