package com.sinosoftgz.sso.cas.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@Component
@ConfigurationProperties(prefix = "sns.wechat")
public class SnsWechatProperties implements InitializingBean {

    public static String CLIENT_ID;

    public static String CLIENT_SECRET;

    public static String REDIRECT_URI;

    private String clientId;

    private String clientSecret;

    private String redirectUri;

    @Override
    public void afterPropertiesSet() {
        CLIENT_ID = clientId;
        CLIENT_SECRET = clientSecret;
        REDIRECT_URI = redirectUri;
    }

}
