package com.sinosoftgz.sso.crm.constant;

/**
 * @author root
 * @version 1.0
 * @ClassName: CrmConstant
 * @description: ${description}
 * @date 2022/2/25 13:06
 */
public class CrmConstant {

    public static final String APP_BASE_CONTEXT = "/crm";

    public static final String APP_BASE_SSO_CONTEXT = "/sso";


    /**
     * 字符串常量：英文问号?
     */
    public static final String QUESTION_MARK = "?";

    /**
     * 字符常量：与 {@code '&'}
     */
    public static final String AMP = "&";

    /**
     * 邮箱正则表达式
     */
    public static final String EMAIL_REGULAR = "^([a-z0-9A-Z]+([-|_|\\.&]|__)?)+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+){0,}\\.)+[a-zA-Z]{2,}$";

    /**
     * 手机号正则表达式
     */
    public static final String PHONE_REGULAR = "^([1][3,4,5,6,7,8,9][0-9]{9}|(950)[0-9]*)$";

    /**
     * sso缓存
     */
    public class CachePrefix {

        private static final String SSO_LOGIN_PREFIX = "SSO:LOGIN:";

        /**
         * 登录用户的token列表。采用list的队列方式，会先设定list的大小，达到list大小后，先移除最先进来的token
         */
        public static final String LOGIN_USER_TOKEN_LIST = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_TOKEN_LIST_";

        /**
         * 登录用户生成的JWT token
         */
        public static final String LOGIN_USER_JWT_TOKEN = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_JWT_TOKEN_";
        /**
         * 登录用户生成的JWT  md5 token
         */
        public static final String LOGIN_USER_JWT_MD5_TOKEN = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_JWT_MD5_TOKEN_";

        /**
         * 根据token信息获取当前用户的userId(快捷检索)
         */
        public static final String LOGIN_USER_ID = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_ID_";

        /**
         * 根据token信息获取当前用户的PASSWORD(快捷检索)
         */
        public static final String LOGIN_USER_PASSWORD = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_PASSWORD_";

        /**
         * 根据token信息获取当前用户的PASSWORD_SHADOW(快捷检索)
         */
        public static final String LOGIN_USER_PASSWORD_SHADOW = SSO_LOGIN_PREFIX + "TOKEN:LOGIN_USER_PASSWORD_SHADOW_";

    }


}
