package com.sinosoftgz.sso.crm.login.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: Roney
 * @date: 2022-05-30 16:35
 * @description: 请求登录接口参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RequestLoginReq implements Serializable {

    /**
     * 参数url
     */
    public static final String PARAMS_URL = "url=";
    /**
     * switchUser
     */
    public static final String PARAMS_SWITCH_USER = "switchUser=";

    /**
     * 登录成功后回调的url
     */
    private String url;

    /**
     * switchUser`为强制重新登录标志，当该标志为`true`时，`sso` 都认为当前为未登录 ，常见应用场景为切换用户
     */
    private boolean switchUser;

    /**
     * 用户平台类型 ipad,mobile,pc，不同的平台类型，跳转的登录页面不一样
     */
    private String userPlatformType;

    public RequestLoginReq(String url, boolean switchUser) {
        this.url = url;
        this.switchUser = switchUser;
    }
}
