package com.sinosoftgz.sso.crm.mail.vo;

import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author root
 * @version 1.0 @ClassName: MailVO
 * @description: ${description}
 * @date 2022/2/28 10:22
 */
@Data
public class MailVO implements Serializable {
    private static final long serialVersionUID = 1L;
    @Email
    private String from;

    @NotNull(message = "收件人邮箱地址不允许为空")
    @NotBlank(message = "收件人邮箱地址不允许为空")
    @NotEmpty(message = "收件人邮箱地址不允许为空")
    //  @Email(message = "收件人邮箱地址格式不符合")
    private String[] to;

    @NotNull(message = "邮件正文不允许为空")
    @NotBlank(message = "邮件正文不允许为空")
    @NotEmpty(message = "邮件正文不允许为空")
    private String text;

    @NotNull(message = "邮件主题不允许为空")
    @NotBlank(message = "邮件主题不允许为空")
    @NotEmpty(message = "邮件主题不允许为空")
    private String subject;

    private String[] cc;
    private String[] bcc;
    private String template;
}
