package com.sinosoftgz.sso.crm.member.request.check;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * 根据用户信息和密码校验用户信息请求对象
 *
 * @author: Roney
 * @date: 2022-06-01 19:05
 * @description: 根据用户信息和密码校验用户信息请求对象
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CheckMemberByUserIdAndPasswordReq {

    /**
     * 用户信息 用户名/邮箱/手机号
     */
    @NotBlank(message = "用户信息 用户名/邮箱/手机号 不能为空")
    private String userId;

    /**
     * 密码，原始密码
     */
    @NotBlank(message = "密码不能为空")
    private String password;
}
