package com.sinosoftgz.sso.crm.member.vo;

import com.sinosoftgz.sso.crm.annotation.Captcha;
import com.sinosoftgz.sso.crm.annotation.Phone;
import com.sinosoftgz.sso.crm.annotation.ResetPasswordSlot;
import com.sinosoftgz.sso.crm.annotation.UserCode;
import com.sinosoftgz.global.common.vo.BaseDomainVO;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author root
 * @version 1.0 @ClassName: MemberVO
 * @description: ${description}
 * @date 2022/2/24 15:00
 */
@Data
public class MemberVO extends BaseDomainVO {
    private static final long serialVersionUID = 1L;

    @NotNull(
            message = "账户不能为空",
            groups = {Register.class}
    )
    @NotEmpty(
            message = "账户不能为空",
            groups = {Register.class}
    )
    @NotBlank(
            message = "账户不能为空",
            groups = {Register.class}
    )
    @UserCode(groups = {Register.class})
    private String username;

    @Email(
            message = "邮件格式不符合",
            groups = {Register.class}
    )
    private String email;

    @Phone(groups = {Register.class})
    private String phone;

    @NotNull(
            message = "密码1不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    @NotEmpty(
            message = "密码1不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    @NotBlank(
            message = "密码1不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    private String password1;

    @NotNull(
            message = "密码2不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    @NotEmpty(
            message = "密码2不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    @NotBlank(
            message = "密码2不能为空",
            groups = {Register.class, ResetPassword.class, forgetPassword.class}
    )
    private String password2;

    private String password;

    @NotNull(
            message = "验证码不能为空",
            groups = {ResetPasswordSetpOne.class, ResetPassword.class}
    )
    @NotEmpty(
            message = "验证码不能为空",
            groups = {ResetPasswordSetpOne.class, ResetPassword.class}
    )
    @NotBlank(
            message = "验证码不能为空",
            groups = {ResetPasswordSetpOne.class, ResetPassword.class}
    )
    @Captcha(groups = {Login.class, ResetPasswordSetpOne.class, ResetPassword.class})
    private String type;

    @NotNull(
            message = "对应找回方式录入不允许为空",
            groups = {ResetPasswordSetpOne.class}
    )
    @NotBlank(
            message = "对应找回方式录入不允许为空",
            groups = {ResetPasswordSetpOne.class}
    )
    @NotEmpty(
            message = "对应找回方式录入不允许为空",
            groups = {ResetPasswordSetpOne.class}
    )
    @ResetPasswordSlot(groups = {ResetPasswordSetpOne.class})
    private String slot;

    private String url;

    /**
     * 需要重定向的url
     */
    private String redirectUrl;

    /**
     * 登录的IP
     */
    private  String loginIp;

    public interface Register {
    }

    public interface ResetPassword {
    }

    public interface ResetPasswordSetpOne {
    }

    public interface Login {
    }

    public interface forgetPassword {
    }
}
