package com.sinosoftgz.sso.crm.token.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 登录类型
 *
 * @author: Roney
 * @date: 2022-05-31 17:04
 * @description: 登录类型
 */
public enum TokenLoginType {

    THIRD("THIRD", "第三方登录"),
    USERNAME_PASSWORD("USERNAME_PASSWORD", "用户密码登录"),
    AUTO("AUTO", "自动登录(长时间登录)"),
    ;

    public static Map<String, TokenLoginType> tokenLoginTypeMap = new ConcurrentHashMap<>();

    static {
        tokenLoginTypeMap.put(THIRD.getType(), THIRD);
        tokenLoginTypeMap.put(USERNAME_PASSWORD.getType(), USERNAME_PASSWORD);
        tokenLoginTypeMap.put(AUTO.getType(), AUTO);
    }

    /**
     * 类型
     */
    private String type;

    /**
     * 备注
     */
    private String remark;

    TokenLoginType(String type, String remark) {
        this.type = type;
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
