package com.sinosoftgz.sso.crm.token.request;

import com.sinosoftgz.sso.crm.token.request.base.BaseClientInfoReq;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 颁发令牌请求对象
 *
 * @author: Roney
 * @date: 2022-05-31 16:18
 * @description: 颁发令牌请求对象
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PromulgateTokenReq extends BaseClientInfoReq implements Serializable {

    /**
     * 用户名/邮箱/用户ID
     */
    private String userId;

    /**
     * 密码
     */
    private String password;

    /**
     * 自动登录或者长时间登录使用('passwordShadow'为第一次使用用户名密码登录时接口返回)
     * 由客户端自行存储，需要使用自动登录场景的时候，需要将此参数传送到服务端
     */
    private String passwordShadow;

    /**
     * 第三方登录的openId
     */
    private String openId;
}
