package com.sinosoftgz.sso.crm.token.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * 刷新token请求对象
 *
 * @author: Roney
 * @date: 2022-06-08 11:58
 * @description: 刷新token请求对象
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RefreshTokenReq {

    /**
     * token信息
     */
    @NotBlank(message = "token信息不能为空")
    private String token;

    /**
     * `returnToken` 该参数表示强制在结果中返回 token
     */
    private boolean returnToken;

    /**
     * `httpOnly` 该参数表示强制结果中set-cookie 不能生成HttpOnly 标志，方便js 直接访问
     */
    private boolean httpOnly;

    /**
     * 当`callback` 参数未送时，直接返回`json`结果,否则使用 `jsonp` 返回结果
     */
    private String callback;

    public RefreshTokenReq(String token) {
        this.token = token;
    }
}
