package com.sinosoftgz.sso.crm.token.request.base;


import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 客户端接入请求对象
 *
 * @author: Roney
 * @date: 2022-05-31 18:11
 * @description: 客户端接入请求对象
 */
@Data
public class BaseClientInfoReq extends BaseLoginTypeReq {

    /**
     * 应用名称
     * 由接入方提供
     */
    @NotBlank(message = "应用名称不能为空")
    private String serviceName;

    /**
     * 由sso提供,每个接入方，SSO会根据应用名称分配appKey
     */
    @NotBlank(message = "appKey不能为空")
    private String appKey;


}
