package com.sinosoftgz.sso.crm.token.request.base;

import com.sinosoftgz.sso.crm.token.enums.TokenLoginType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * 登录类型
 * 不同的登录类型，参数不一样，为了方便做判断增加类型，客户端传
 *
 * @author: Roney
 * @date: 2022-05-31 17:02
 * @description: 登录类型
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseLoginTypeReq extends BaseSecurityReq {
    /**
     * 登录类型
     *
     * @see TokenLoginType
     */
    @NotNull(message = "登录类型不能为空")
    private String loginType;
}
