package com.sinosoftgz.sso.crm.token.request.base;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * 加密串
 *
 * @author: Roney
 * @date: 2022-05-31 16:54
 * @description: 加密串
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseSecurityReq {

    /**
     * 加密串，生成方式md5([userid|openid]+app_key)*5
     * 根据不同的类型加密串的规则不一样
     * app_key为接入系统和sso互信的唯一凭证
     */
    @NotBlank(message = "加密串不能为空")
    private String security;
}
