package com.sinosoftgz.sso.crm.token.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 颁发令牌返回对象
 *
 * @author: Roney
 * @date: 2022-05-31 17:25
 * @description: 颁发令牌返回对象
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PromulgateTokenResp implements Serializable {

    /**
     * 用户名/邮箱/用户ID
     */
    private String userId;


    /**
     * 使用用户名和密码登录场景会返回，其他场景不返回此字段,业务系统自行保存
     */
    private String passwordShadow;

    /**
     * token信息
     */
    private String token;

    public PromulgateTokenResp(String userId, String token) {
        this.userId = userId;
        this.token = token;
    }
}
