package com.sinosoftgz.sso.crm.validCode.vo;

import com.sinosoftgz.sso.crm.annotation.Phone;
import com.sinosoftgz.global.common.vo.BaseDomainVO;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;

/**
 * @author root
 * @version 1.0 @ClassName: MemberVO
 * @description: ${description}
 * @date 2022/2/24 15:00
 */
@Data
public class ValidCodeVO extends BaseDomainVO {
    private static final long serialVersionUID = 1L;


    @Email(
            message = "邮件格式不符合",
            groups = {ValidCode.class}
    )
    private String email;

    @Phone(groups = {ValidCode.class})
    private String phone;

    @NotBlank(
            message = "验证码不能为空",
            groups = {ValidCode.class}
    )
    private String code;

    @NotBlank(
            message = "验证码不能为空",
            groups = {ValidCode.class}
    )
    private String key;

    //校验来源
    private String business;

    //是否需要校验账号
    private Boolean needJudge;

    public interface ValidCode {
    }
}
