package com.sinosoftgz.starter.template.freemarker.config;

import com.sinosoftgz.starter.template.freemarker.properties.FreemarkerProperties;
import com.sinosoftgz.starter.template.freemarker.template.EncodeUrlMethod;
import com.sinosoftgz.starter.template.freemarker.constant.FreemarkerConstant;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import javax.servlet.ServletContext;


/**
 * Created by Roney on 2019/8/17.
 *
 * @author Roney
 * @date 2019-08-17 19:21
 */
@Configuration
@EnableConfigurationProperties(FreemarkerProperties.class)
@Data
public class FreemarkerConfiguration implements InitializingBean, ServletContextAware {

    private FreemarkerProperties freemarkerProperties;

    private FreeMarkerConfigurer freeMarkerConfigurer;

    private ResourceUrlProvider resourceUrlProvider;

    public FreemarkerConfiguration(FreemarkerProperties freemarkerProperties, FreeMarkerConfigurer freeMarkerConfigurer, ResourceUrlProvider resourceUrlProvider) {
        this.freemarkerProperties = freemarkerProperties;
        this.freeMarkerConfigurer = freeMarkerConfigurer;
        this.resourceUrlProvider = resourceUrlProvider;
    }

    @Bean
    public EncodeUrlMethod encodeUrlMethod() {
        return new EncodeUrlMethod(resourceUrlProvider);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //设置各个内容的访问前缀，没有配置为contextpath
        freemarker.template.Configuration configuration = freeMarkerConfigurer.getConfiguration();
        String projectContextPath = servletContext.getContextPath();
        configuration.setSharedVariable(FreemarkerConstant.Content.C_STATIC, projectContextPath);
        if (StringUtils.hasLength(freemarkerProperties.getContent().getCommonStatic())) {
            configuration.setSharedVariable(FreemarkerConstant.Content.C_STATIC, freemarkerProperties.getContent().getCommonStatic());
        }
        configuration.setSharedVariable(FreemarkerConstant.Content.P_STATIC, projectContextPath);
        if (StringUtils.hasLength(freemarkerProperties.getContent().getProjectStatic())) {
            configuration.setSharedVariable(FreemarkerConstant.Content.P_STATIC, freemarkerProperties.getContent().getProjectStatic());
        }
        configuration.setSharedVariable(FreemarkerConstant.Content.CTX, projectContextPath);
        if (StringUtils.hasLength(freemarkerProperties.getContent().getCtx())) {
            configuration.setSharedVariable(FreemarkerConstant.Content.CTX, freemarkerProperties.getContent().getCtx());
        }
        freeMarkerConfigurer.getConfiguration().setSharedVariable(FreemarkerConstant.Content.VERSION, encodeUrlMethod());
    }

    ServletContext servletContext;

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}
