package com.sinosoftgz.starter.template.freemarker.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author: Roney
 * @date: 2022-02-28 15:49
 * @description: FreemarkerProperties
 */

@ConfigurationProperties(prefix = FreemarkerProperties.FREEMARKER_PREFIX)
@Data
public class FreemarkerProperties {

    public static final String FREEMARKER_PREFIX = "freemarker";

    /**
     * 设置上下文等路径
     */
    @NestedConfigurationProperty
    private Content content = new Content();

    @Data
    public static class Content {

        /**
         * 公共静态文件路径
         */

        private String commonStatic;
        /**
         * 项目静态文件路径
         */

        private String projectStatic;
        /**
         * 项目静态内容路径
         */
        private String ctx;

    }
}
