package com.sinosoftgz.starter.template.freemarker.template;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import org.springframework.web.servlet.resource.ResourceUrlProvider;


import java.util.List;

/**
 * Created by Roney on 2019/8/17.
 * Freemarker自定义方法
 * 实现response.encodeURL(url)功能
 *
 * @author Roney
 * @date 2019-08-17 19:21
 */
public class EncodeUrlMethod implements TemplateMethodModelEx {

    public EncodeUrlMethod(ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    ResourceUrlProvider resourceUrlProvider;

    /**
     * 执行方法
     *
     * @param argList 方法参数列表
     * @return Object 方法返回值
     * @throws TemplateModelException
     */
    @Override
    public Object exec(List argList) throws TemplateModelException {
        //限定方法中必须且只能传递一个参数
        if (argList.size() != 1) {
            throw new TemplateModelException("Wrong arguments!");
        }
        //返回response.encodeURL执行结果
        String url = resourceUrlProvider.getForLookupPath(argList.get(0).toString());
        if (url == null || "".equals(url.trim())) {
            return argList.get(0).toString();
        }
        return url;
    }
}