/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.template.freemarker.config;

import com.sinosoftgz.starter.template.freemarker.properties.FreemarkerProperties;
import com.sinosoftgz.starter.template.freemarker.template.EncodeUrlMethod;
import freemarker.template.TemplateModel;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableConfigurationProperties(value={FreemarkerProperties.class})
public class FreemarkerConfiguration
implements InitializingBean,
ServletContextAware {
    private FreemarkerProperties freemarkerProperties;
    private FreeMarkerConfigurer freeMarkerConfigurer;
    private ResourceUrlProvider resourceUrlProvider;
    ServletContext servletContext;

    public FreemarkerConfiguration(FreemarkerProperties freemarkerProperties, FreeMarkerConfigurer freeMarkerConfigurer, ResourceUrlProvider resourceUrlProvider) {
        this.freemarkerProperties = freemarkerProperties;
        this.freeMarkerConfigurer = freeMarkerConfigurer;
        this.resourceUrlProvider = resourceUrlProvider;
    }

    @Bean
    public EncodeUrlMethod encodeUrlMethod() {
        return new EncodeUrlMethod(this.resourceUrlProvider);
    }

    public void afterPropertiesSet() throws Exception {
        freemarker.template.Configuration configuration = this.freeMarkerConfigurer.getConfiguration();
        String projectContextPath = this.servletContext.getContextPath();
        configuration.setSharedVariable("c_static", (Object)projectContextPath);
        if (StringUtils.hasLength((String)this.freemarkerProperties.getContent().getCommonStatic())) {
            configuration.setSharedVariable("c_static", (Object)this.freemarkerProperties.getContent().getCommonStatic());
        }
        configuration.setSharedVariable("p_static", (Object)projectContextPath);
        if (StringUtils.hasLength((String)this.freemarkerProperties.getContent().getProjectStatic())) {
            configuration.setSharedVariable("p_static", (Object)this.freemarkerProperties.getContent().getProjectStatic());
        }
        configuration.setSharedVariable("ctx", (Object)projectContextPath);
        if (StringUtils.hasLength((String)this.freemarkerProperties.getContent().getCtx())) {
            configuration.setSharedVariable("ctx", (Object)this.freemarkerProperties.getContent().getCtx());
        }
        this.freeMarkerConfigurer.getConfiguration().setSharedVariable("_v", (TemplateModel)this.encodeUrlMethod());
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public FreemarkerProperties getFreemarkerProperties() {
        return this.freemarkerProperties;
    }

    public FreeMarkerConfigurer getFreeMarkerConfigurer() {
        return this.freeMarkerConfigurer;
    }

    public ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setFreemarkerProperties(FreemarkerProperties freemarkerProperties) {
        this.freemarkerProperties = freemarkerProperties;
    }

    public void setFreeMarkerConfigurer(FreeMarkerConfigurer freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public void setResourceUrlProvider(ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreemarkerConfiguration)) {
            return false;
        }
        FreemarkerConfiguration other = (FreemarkerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FreemarkerProperties this$freemarkerProperties = this.getFreemarkerProperties();
        FreemarkerProperties other$freemarkerProperties = other.getFreemarkerProperties();
        if (this$freemarkerProperties == null ? other$freemarkerProperties != null : !((Object)this$freemarkerProperties).equals(other$freemarkerProperties)) {
            return false;
        }
        FreeMarkerConfigurer this$freeMarkerConfigurer = this.getFreeMarkerConfigurer();
        FreeMarkerConfigurer other$freeMarkerConfigurer = other.getFreeMarkerConfigurer();
        if (this$freeMarkerConfigurer == null ? other$freeMarkerConfigurer != null : !this$freeMarkerConfigurer.equals(other$freeMarkerConfigurer)) {
            return false;
        }
        ResourceUrlProvider this$resourceUrlProvider = this.getResourceUrlProvider();
        ResourceUrlProvider other$resourceUrlProvider = other.getResourceUrlProvider();
        if (this$resourceUrlProvider == null ? other$resourceUrlProvider != null : !this$resourceUrlProvider.equals(other$resourceUrlProvider)) {
            return false;
        }
        ServletContext this$servletContext = this.getServletContext();
        ServletContext other$servletContext = other.getServletContext();
        return !(this$servletContext == null ? other$servletContext != null : !this$servletContext.equals(other$servletContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FreemarkerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FreemarkerProperties $freemarkerProperties = this.getFreemarkerProperties();
        result = result * 59 + ($freemarkerProperties == null ? 43 : ((Object)$freemarkerProperties).hashCode());
        FreeMarkerConfigurer $freeMarkerConfigurer = this.getFreeMarkerConfigurer();
        result = result * 59 + ($freeMarkerConfigurer == null ? 43 : $freeMarkerConfigurer.hashCode());
        ResourceUrlProvider $resourceUrlProvider = this.getResourceUrlProvider();
        result = result * 59 + ($resourceUrlProvider == null ? 43 : $resourceUrlProvider.hashCode());
        ServletContext $servletContext = this.getServletContext();
        result = result * 59 + ($servletContext == null ? 43 : $servletContext.hashCode());
        return result;
    }

    public String toString() {
        return "FreemarkerConfiguration(freemarkerProperties=" + this.getFreemarkerProperties() + ", freeMarkerConfigurer=" + this.getFreeMarkerConfigurer() + ", resourceUrlProvider=" + this.getResourceUrlProvider() + ", servletContext=" + this.getServletContext() + ")";
    }
}

