/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DDHHMM = "yyyy-MM-dd HH:mm";
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.YYYY_MM_DDHHMM);
        }
    };

    public static String format(Date date) {
        return threadLocal.get().format(date);
    }

    public static Date parse(String textDate) throws ParseException {
        return threadLocal.get().parse(textDate);
    }

    public static String now(DateTime dateTime, String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        String dateTimeStr = formatter.print((ReadableInstant)dateTime);
        return dateTimeStr;
    }

    public static Date nowDate() {
        DateTime dateTime = new DateTime();
        return new Date(dateTime.getMillis());
    }

    public static Date nowBeforeSecondsDate(int seconds) {
        DateTime dateTime = new DateTime();
        dateTime = dateTime.minusSeconds(seconds);
        return new Date(dateTime.getMillis());
    }
}

