/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.dbi.BackupManager;
import com.sleepycat.json_simple.JsonException;
import com.sleepycat.json_simple.JsonKey;
import com.sleepycat.json_simple.JsonObject;
import com.sleepycat.json_simple.Jsoner;
import com.sleepycat.utilint.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class SnapshotManifest {
    private static final boolean PRETTY_PRINT = true;
    private static final String MD_FORMAT = "SHA-256";
    private static final int CURRENT_VERSION = 1;
    private final int version;
    private final int sequence;
    private final String snapshot;
    private final long startTimeMs;
    private final long lastFileCopiedTimeMs;
    private final String nodeName;
    private final String checksum;
    private final long endOfLog;
    private final boolean isMaster;
    private final boolean isComplete;
    private final SortedMap<String, LogFileInfo> snapshotFiles;
    private final SortedMap<String, LogFileInfo> erasedFiles;

    private SnapshotManifest(int version, int sequence, String snapshot, long startTimeMs, long lastFileCopiedTimeMs, String nodeName, String checksum, long endOfLog, boolean isMaster, boolean isComplete, SortedMap<String, LogFileInfo> snapshotFiles, SortedMap<String, LogFileInfo> erasedFiles) {
        this.version = version;
        this.sequence = sequence;
        this.snapshot = snapshot;
        this.startTimeMs = startTimeMs;
        this.lastFileCopiedTimeMs = lastFileCopiedTimeMs;
        this.nodeName = nodeName;
        this.endOfLog = endOfLog;
        this.isMaster = isMaster;
        this.isComplete = isComplete;
        this.snapshotFiles = snapshotFiles;
        this.erasedFiles = erasedFiles;
        this.validate();
        this.checksum = checksum == null ? this.computeChecksum() : checksum;
    }

    private SnapshotManifest(JsonObject json) {
        String expectedChecksum;
        Integer versionValue = json.getInteger(JsonField.version);
        this.version = versionValue != null ? versionValue : 0;
        this.sequence = SnapshotManifest.getInteger(json, JsonField.sequence);
        this.snapshot = json.getString(JsonField.snapshot);
        this.startTimeMs = SnapshotManifest.getLong(json, JsonField.startTimeMs);
        this.lastFileCopiedTimeMs = SnapshotManifest.getLong(json, JsonField.lastFileCopiedTimeMs);
        this.nodeName = json.getString(JsonField.nodeName);
        this.checksum = json.getString(JsonField.checksum);
        this.endOfLog = SnapshotManifest.getLong(json, JsonField.endOfLog);
        this.isMaster = SnapshotManifest.getBoolean(json, JsonField.isMaster);
        this.isComplete = SnapshotManifest.getBoolean(json, JsonField.isComplete);
        this.snapshotFiles = SnapshotManifest.getLogFileMap(json, JsonField.snapshotFiles);
        this.erasedFiles = SnapshotManifest.getLogFileMap(json, JsonField.erasedFiles);
        this.validate();
        if (!"0".equals(this.checksum) && !(expectedChecksum = this.computeChecksum()).equals(this.checksum)) {
            throw new IllegalArgumentException("Incorrect checksum: expected " + expectedChecksum + ", found " + this.checksum);
        }
    }

    private static int getInteger(JsonObject json, JsonKey field) {
        Integer value = json.getInteger(field);
        if (value == null) {
            throw new IllegalArgumentException("Missing field: " + field);
        }
        return value;
    }

    private static long getLong(JsonObject json, JsonKey field) {
        Long value = json.getLong(field);
        if (value == null) {
            throw new IllegalArgumentException("Missing field: " + field);
        }
        return value;
    }

    private static boolean getBoolean(JsonObject json, JsonKey field) {
        Boolean value = json.getBoolean(field);
        if (value == null) {
            throw new IllegalArgumentException("Missing field: " + field);
        }
        return value;
    }

    private static SortedMap<String, LogFileInfo> getLogFileMap(JsonObject json, JsonField field) {
        Object jsonMap = json.getMap(field);
        if (jsonMap == null) {
            throw new IllegalArgumentException("Missing field: " + field);
        }
        TreeMap<String, LogFileInfo> logFileMap = new TreeMap<String, LogFileInfo>();
        for (Map.Entry entry : jsonMap.entrySet()) {
            String key = (String)entry.getKey();
            JsonObject value = (JsonObject)entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Key " + key + " missing for field " + field);
            }
            logFileMap.put(key, new LogFileInfo(value));
        }
        return logFileMap;
    }

    SortedMap<String, Object> toJsonMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(JsonField.version.name(), this.version);
        map.put(JsonField.sequence.name(), this.sequence);
        map.put(JsonField.snapshot.name(), this.snapshot);
        map.put(JsonField.startTimeMs.name(), this.startTimeMs);
        map.put(JsonField.lastFileCopiedTimeMs.name(), this.lastFileCopiedTimeMs);
        map.put(JsonField.nodeName.name(), this.nodeName);
        map.put(JsonField.checksum.name(), this.checksum);
        map.put(JsonField.endOfLog.name(), this.endOfLog);
        map.put(JsonField.isMaster.name(), this.isMaster);
        map.put(JsonField.isComplete.name(), this.isComplete);
        map.put(JsonField.snapshotFiles.name(), this.getJsonMap(this.snapshotFiles));
        map.put(JsonField.erasedFiles.name(), this.getJsonMap(this.erasedFiles));
        return map;
    }

    private SortedMap<String, Object> getJsonMap(SortedMap<String, LogFileInfo> logFileMap) {
        TreeMap<String, Object> jsonMap = new TreeMap<String, Object>();
        for (Map.Entry<String, LogFileInfo> entry : logFileMap.entrySet()) {
            jsonMap.put(entry.getKey(), entry.getValue().toJsonMap());
        }
        return jsonMap;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getLastFileCopiedTimeMs() {
        return this.lastFileCopiedTimeMs;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public long getEndOfLog() {
        return this.endOfLog;
    }

    public boolean getIsMaster() {
        return this.isMaster;
    }

    public boolean getIsComplete() {
        return this.isComplete;
    }

    public SortedMap<String, LogFileInfo> getSnapshotFiles() {
        return this.snapshotFiles;
    }

    public SortedMap<String, LogFileInfo> getErasedFiles() {
        return this.erasedFiles;
    }

    public byte[] serialize() throws IOException {
        return SnapshotManifest.serialize(this.toJsonMap());
    }

    static byte[] serialize(SortedMap<String, Object> map) throws IOException {
        StringWriter writer = new StringWriter(512);
        Jsoner.serialize(map, writer);
        String result = Jsoner.prettyPrint(((Object)writer).toString());
        return result.getBytes("UTF-8");
    }

    public static SnapshotManifest deserialize(byte[] bytes) throws IOException {
        try {
            return new SnapshotManifest(SnapshotManifest.deserializeToJson(bytes));
        }
        catch (JsonException | RuntimeException e) {
            String msg = e.getMessage();
            throw new IOException(msg != null ? msg : e.toString(), e);
        }
    }

    static JsonObject deserializeToJson(byte[] bytes) throws JsonException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
        return (JsonObject)Jsoner.deserialize(reader);
    }

    public void validate() {
        if (this.version == 0) {
            return;
        }
        if (this.version < 0) {
            throw new IllegalArgumentException("version must not be less than 0: " + this.version);
        }
        if (this.sequence < 1) {
            throw new IllegalArgumentException("sequence must not be less than 1: " + this.sequence);
        }
        SnapshotManifest.checkNull("snapshot", this.snapshot);
        if (!BackupManager.SNAPSHOT_PATTERN.matcher(this.snapshot).matches()) {
            throw new IllegalArgumentException("snapshot name is invalid: " + this.snapshot);
        }
        if (this.startTimeMs <= 0L) {
            throw new IllegalArgumentException("startTimeMs must be greater than 0: " + this.startTimeMs);
        }
        if (this.lastFileCopiedTimeMs < 0L) {
            throw new IllegalArgumentException("lastFileCopiedTimeMs must not be less than 0: " + this.lastFileCopiedTimeMs);
        }
        SnapshotManifest.checkNull("nodeName", this.nodeName);
        if (this.endOfLog < -1L) {
            throw new IllegalArgumentException("endOfLog must not be less than -1");
        }
        SnapshotManifest.checkNull("snapshotFiles", this.snapshotFiles);
        this.snapshotFiles.forEach((logFile, info) -> {
            SnapshotManifest.checkNull("snapshotFile info for " + logFile, info);
            if (!info.getIsCopied()) {
                if (this.isComplete) {
                    throw new IllegalArgumentException("snapshot cannot be complete when a log file was not copied: " + logFile);
                }
            } else if (this.snapshot.equals(info.getSnapshot())) {
                this.validateCopiedFile((String)logFile, (LogFileInfo)info);
            }
        });
        SnapshotManifest.checkNull("erasedFiles", this.erasedFiles);
        this.erasedFiles.forEach((logFile, info) -> {
            SnapshotManifest.checkNull("erasedFile info for " + logFile, info);
            if (info.getIsCopied()) {
                if (!this.snapshot.equals(info.getSnapshot())) {
                    throw new IllegalArgumentException("Snapshot " + this.snapshot + " does not match snapshot for copied erased file " + logFile + ": " + info.getSnapshot());
                }
                this.validateCopiedFile((String)logFile, (LogFileInfo)info);
            }
        });
    }

    private void validateCopiedFile(String logFile, LogFileInfo info) {
        assert (info.getIsCopied());
        assert (this.snapshot.equals(info.getSnapshot()));
        long copyStartTimeMs = info.getCopyStartTimeMs();
        if (copyStartTimeMs < this.startTimeMs) {
            throw new IllegalArgumentException("copyStartTimeMs " + copyStartTimeMs + " for file " + logFile + " must not be less than startTimeMs " + this.startTimeMs);
        }
        if (copyStartTimeMs > this.lastFileCopiedTimeMs) {
            throw new IllegalArgumentException("lastFileCopiedTimeMs " + this.lastFileCopiedTimeMs + " must not be less than copyStartTimeMs " + copyStartTimeMs + " for file " + logFile);
        }
    }

    private static void checkNull(String fieldName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(fieldName + " must not be null");
        }
    }

    private String computeChecksum() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(MD_FORMAT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected failure: " + e, e);
        }
        this.tallyChecksum(md);
        return BackupManager.checksumToHex(md.digest());
    }

    private void tallyChecksum(MessageDigest md) {
        SnapshotManifest.tallyChecksumInt(md, this.version);
        SnapshotManifest.tallyChecksumInt(md, this.sequence);
        SnapshotManifest.tallyChecksumString(md, this.snapshot);
        SnapshotManifest.tallyChecksumLong(md, this.startTimeMs);
        SnapshotManifest.tallyChecksumLong(md, this.lastFileCopiedTimeMs);
        SnapshotManifest.tallyChecksumString(md, this.nodeName);
        SnapshotManifest.tallyChecksumLong(md, this.endOfLog);
        SnapshotManifest.tallyChecksumBoolean(md, this.isMaster);
        SnapshotManifest.tallyChecksumBoolean(md, this.isComplete);
        SnapshotManifest.tallyChecksum(md, this.snapshotFiles);
        SnapshotManifest.tallyChecksum(md, this.erasedFiles);
    }

    private static void tallyChecksumString(MessageDigest md, String value) {
        md.update(StringUtils.toUTF8(value));
    }

    private static void tallyChecksumBoolean(MessageDigest md, boolean value) {
        md.update((byte)(value ? 1 : 0));
    }

    private static void tallyChecksumInt(MessageDigest md, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        md.update(bytes);
    }

    private static void tallyChecksumLong(MessageDigest md, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        md.update(bytes);
    }

    private static void tallyChecksum(MessageDigest md, SortedMap<String, LogFileInfo> logFileMap) {
        SnapshotManifest.tallyChecksumInt(md, logFileMap.size());
        logFileMap.forEach((k, v) -> {
            SnapshotManifest.tallyChecksumString(md, k);
            v.tallyChecksum(md);
        });
    }

    public String toString() {
        return "SnapshotManifest[version:" + this.version + " sequence:" + this.sequence + " snapshot:" + this.snapshot + " startTimeMs:" + this.startTimeMs + " lastFileCopiedTimeMs:" + this.lastFileCopiedTimeMs + " nodeName:" + this.nodeName + " checksum:" + this.checksum + " endOfLog:" + this.endOfLog + " isMaster:" + this.isMaster + " isComplete:" + this.isComplete + " snapshotFiles:" + this.snapshotFiles + " erasedFiles:" + this.erasedFiles + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SnapshotManifest)) {
            return false;
        }
        SnapshotManifest other = (SnapshotManifest)object;
        return this.version == other.version && this.sequence == other.sequence && Objects.equals(this.snapshot, other.snapshot) && this.startTimeMs == other.startTimeMs && this.lastFileCopiedTimeMs == other.lastFileCopiedTimeMs && Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.checksum, other.checksum) && this.endOfLog == other.endOfLog && this.isMaster == other.isMaster && this.isComplete == other.isComplete && Objects.equals(this.snapshotFiles, other.snapshotFiles) && Objects.equals(this.erasedFiles, other.erasedFiles);
    }

    public int hashCode() {
        int hash = 41;
        hash = 43 * hash + this.version;
        hash = 43 * hash + this.sequence;
        hash = 43 * hash + Objects.hashCode(this.snapshot);
        hash = 43 * hash + Long.hashCode(this.startTimeMs);
        hash = 43 * hash + Long.hashCode(this.lastFileCopiedTimeMs);
        hash = 43 * hash + Objects.hashCode(this.nodeName);
        hash = 43 * hash + Objects.hashCode(this.checksum);
        hash = 43 * hash + Long.hashCode(this.endOfLog);
        hash = 43 * hash + Boolean.hashCode(this.isMaster);
        hash = 43 * hash + Boolean.hashCode(this.isComplete);
        hash = 43 * hash + Objects.hashCode(this.snapshotFiles);
        hash = 43 * hash + Objects.hashCode(this.erasedFiles);
        return hash;
    }

    public static class LogFileInfo {
        private final String checksum;
        private final boolean isCopied;
        private final long copyStartTimeMs;
        private final String snapshot;
        private final String nodeName;

        public LogFileInfo(String checksum, boolean isCopied, long copyStartTimeMs, String snapshot, String nodeName) {
            this.checksum = checksum;
            this.isCopied = isCopied;
            this.copyStartTimeMs = copyStartTimeMs;
            this.snapshot = snapshot;
            this.nodeName = nodeName;
            this.validate();
        }

        public LogFileInfo(String snapshot, String nodeName) {
            this.checksum = "0";
            this.isCopied = false;
            this.copyStartTimeMs = 0L;
            this.snapshot = snapshot;
            this.nodeName = nodeName;
            this.validate();
        }

        public LogFileInfo(String checksum, long copyStartTimeMs, SnapshotManifest manifest) {
            this.checksum = checksum;
            this.isCopied = true;
            this.copyStartTimeMs = copyStartTimeMs;
            this.snapshot = manifest.getSnapshot();
            this.nodeName = manifest.getNodeName();
            this.validate();
        }

        LogFileInfo(JsonObject json) {
            this.checksum = json.getString(JsonField.checksum);
            this.isCopied = SnapshotManifest.getBoolean(json, JsonField.isCopied);
            this.copyStartTimeMs = SnapshotManifest.getLong(json, JsonField.copyStartTimeMs);
            this.snapshot = json.getString(JsonField.snapshot);
            this.nodeName = json.getString(JsonField.nodeName);
            this.validate();
        }

        SortedMap<String, Object> toJsonMap() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put(JsonField.checksum.name(), this.checksum);
            map.put(JsonField.isCopied.name(), this.isCopied);
            map.put(JsonField.copyStartTimeMs.name(), this.copyStartTimeMs);
            map.put(JsonField.snapshot.name(), this.snapshot);
            map.put(JsonField.nodeName.name(), this.nodeName);
            return map;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public boolean getIsCopied() {
            return this.isCopied;
        }

        public long getCopyStartTimeMs() {
            return this.copyStartTimeMs;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void validate() {
            SnapshotManifest.checkNull("checksum", this.checksum);
            if (this.isCopied && "0".equals(this.checksum)) {
                throw new IllegalArgumentException("checksum for copied entry must not be \"0\"");
            }
            if (this.copyStartTimeMs < 0L) {
                throw new IllegalArgumentException("copyStartTimeMs must not be negative: " + this.copyStartTimeMs);
            }
            if (this.isCopied && this.copyStartTimeMs == 0L) {
                throw new IllegalArgumentException("copyStartTimeMs for copied entry must not be 0");
            }
            SnapshotManifest.checkNull("snapshot", this.snapshot);
            if (!BackupManager.SNAPSHOT_PATTERN.matcher(this.snapshot).matches()) {
                throw new IllegalArgumentException("snapshot name is invalid: " + this.snapshot);
            }
            SnapshotManifest.checkNull("nodeName", this.nodeName);
        }

        void tallyChecksum(MessageDigest md) {
            SnapshotManifest.tallyChecksumString(md, this.checksum);
            SnapshotManifest.tallyChecksumBoolean(md, this.isCopied);
            SnapshotManifest.tallyChecksumLong(md, this.copyStartTimeMs);
            SnapshotManifest.tallyChecksumString(md, this.snapshot);
            SnapshotManifest.tallyChecksumString(md, this.nodeName);
        }

        public String toString() {
            return "LogFileInfo[checksum:" + this.checksum + " isCopied:" + this.isCopied + " copyStartTimeMs:" + this.copyStartTimeMs + " snapshot:" + this.snapshot + " nodeName:" + this.nodeName + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LogFileInfo)) {
                return false;
            }
            LogFileInfo other = (LogFileInfo)object;
            return Objects.equals(this.checksum, other.checksum) && this.isCopied == other.isCopied && this.copyStartTimeMs == other.copyStartTimeMs && Objects.equals(this.snapshot, other.snapshot) && Objects.equals(this.nodeName, other.nodeName);
        }

        public int hashCode() {
            int hash = 71;
            hash = 73 * hash + Objects.hashCode(this.checksum);
            hash = 73 * hash + Boolean.hashCode(this.isCopied);
            hash = 73 * hash + Long.hashCode(this.copyStartTimeMs);
            hash = 73 * hash + Objects.hashCode(this.snapshot);
            hash = 73 * hash + Objects.hashCode(this.nodeName);
            return hash;
        }

        private static enum JsonField implements JsonKey
        {
            checksum,
            isCopied,
            copyStartTimeMs,
            snapshot,
            nodeName;


            @Override
            public String getKey() {
                return this.name();
            }

            @Override
            public Object getValue() {
                return null;
            }
        }
    }

    private static enum JsonField implements JsonKey
    {
        version,
        sequence,
        snapshot,
        startTimeMs,
        lastFileCopiedTimeMs,
        nodeName,
        checksum,
        endOfLog,
        isMaster,
        isComplete,
        snapshotFiles,
        erasedFiles;


        @Override
        public String getKey() {
            return this.name();
        }

        @Override
        public Object getValue() {
            return null;
        }
    }

    public static class Builder {
        private int version = 1;
        private int sequence = 1;
        private String snapshot;
        private long startTimeMs;
        private long lastFileCopiedTimeMs;
        private String nodeName;
        private String checksum;
        private long endOfLog;
        private boolean isMaster;
        private boolean isComplete;
        private final SortedMap<String, LogFileInfo> snapshotFiles;
        private final SortedMap<String, LogFileInfo> erasedFiles;

        public Builder() {
            this.snapshotFiles = new TreeMap<String, LogFileInfo>();
            this.erasedFiles = new TreeMap<String, LogFileInfo>();
        }

        public Builder(SnapshotManifest base) {
            this.sequence = base.getSequence();
            this.snapshot = base.getSnapshot();
            this.startTimeMs = base.getStartTimeMs();
            this.lastFileCopiedTimeMs = base.getLastFileCopiedTimeMs();
            this.nodeName = base.getNodeName();
            this.endOfLog = base.getEndOfLog();
            this.isMaster = base.getIsMaster();
            this.isComplete = base.getIsComplete();
            this.snapshotFiles = new TreeMap<String, LogFileInfo>(base.getSnapshotFiles());
            this.erasedFiles = new TreeMap<String, LogFileInfo>(base.getErasedFiles());
        }

        public SnapshotManifest build() {
            return new SnapshotManifest(this.version, this.sequence, this.snapshot, this.startTimeMs, this.lastFileCopiedTimeMs, this.nodeName, this.checksum, this.endOfLog, this.isMaster, this.isComplete, this.snapshotFiles, this.erasedFiles);
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setSequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder setStartTimeMs(long startTimeMs) {
            this.startTimeMs = startTimeMs;
            return this;
        }

        public Builder setLastFileCopiedTimeMs(long lastFileCopiedTimeMs) {
            this.lastFileCopiedTimeMs = lastFileCopiedTimeMs;
            return this;
        }

        public Builder setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setEndOfLog(long endOfLog) {
            this.endOfLog = endOfLog;
            return this;
        }

        public Builder setIsMaster(boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public Builder setIsComplete(boolean isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        public SortedMap<String, LogFileInfo> getSnapshotFiles() {
            return this.snapshotFiles;
        }

        public SortedMap<String, LogFileInfo> getErasedFiles() {
            return this.erasedFiles;
        }
    }
}

