/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;

public class SecondaryCursor
extends Cursor {
    private final SecondaryDatabase secondaryDb;
    private final Database primaryDb;

    SecondaryCursor(SecondaryDatabase dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, txn, cursorConfig);
        this.secondaryDb = dbHandle;
        this.primaryDb = dbHandle.getPrimaryDatabase();
    }

    SecondaryCursor(SecondaryDatabase dbHandle, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, locker, cursorConfig);
        this.secondaryDb = dbHandle;
        this.primaryDb = dbHandle.getPrimaryDatabase();
    }

    private SecondaryCursor(SecondaryCursor cursor, boolean samePosition) throws DatabaseException {
        super(cursor, samePosition);
        this.secondaryDb = cursor.secondaryDb;
        this.primaryDb = cursor.primaryDb;
    }

    public Database getPrimaryDatabase() {
        return this.primaryDb;
    }

    public SecondaryCursor dup(boolean samePosition) throws DatabaseException {
        this.checkState(false);
        return new SecondaryCursor(this, samePosition);
    }

    public SecondaryCursor dupSecondary(boolean samePosition) throws DatabaseException {
        return this.dup(samePosition);
    }

    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException, IllegalStateException {
        Locker locker;
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "SecondaryCursor.delete: ", null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry pKey = new DatabaseEntry();
        OperationStatus status = this.getCurrentInternal(key, pKey, LockMode.RMW);
        if (status == OperationStatus.SUCCESS && (status = this.primaryDb.deleteInternal(locker = this.cursorImpl.getLocker(), pKey, null)) != OperationStatus.SUCCESS) {
            SecondaryDatabase secDb = (SecondaryDatabase)this.getDatabase();
            throw secDb.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
        }
        return status;
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putCurrent(DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getCurrent(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getCurrent: ", lockMode);
        return this.getCurrentInternal(key, pKey, data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getFirst(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getFirst: ", lockMode);
        return this.position(key, pKey, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getLast(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getLast: ", lockMode);
        return this.position(key, pKey, data, lockMode, false);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNext(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNext: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, true);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextDup: ", lockMode);
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextNoDup: ", null, null, lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, true);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrev(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrev: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevDup: ", lockMode);
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_NODUP);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKey(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKeyRange(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKeyRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    private OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status = this.getCurrentInternal(key, pKey, lockMode);
        if (status == OperationStatus.SUCCESS) {
            status = this.readPrimaryAfterGet(key, pKey, data, lockMode, 0);
        }
        return status;
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        int retries = 0;
        byte[] lastKey = null;
        OperationStatus status;
        while ((status = this.search(key, pKey, lockMode, searchMode)) == OperationStatus.SUCCESS) {
            if (!Arrays.equals(lastKey, key.getData())) {
                retries = 0;
                lastKey = key.getData();
            }
            if ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode, retries)) == OperationStatus.SUCCESS) {
                return status;
            }
            ++retries;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
            }
        }
        return status;
    }

    OperationStatus position(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean first) throws DatabaseException {
        int retries = 0;
        byte[] lastKey = null;
        OperationStatus status;
        while ((status = this.position(key, pKey, lockMode, first)) == OperationStatus.SUCCESS) {
            if (!Arrays.equals(lastKey, key.getData())) {
                retries = 0;
                lastKey = key.getData();
            }
            if ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode, retries)) == OperationStatus.SUCCESS) {
                return status;
            }
            ++retries;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
            }
        }
        return status;
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, GetMode getMode) throws DatabaseException {
        int retries = 0;
        byte[] lastKey = null;
        OperationStatus status;
        while ((status = this.retrieveNext(key, pKey, lockMode, getMode)) == OperationStatus.SUCCESS) {
            if (!Arrays.equals(lastKey, key.getData())) {
                retries = 0;
                lastKey = key.getData();
            }
            if ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode, retries)) == OperationStatus.SUCCESS) {
                return status;
            }
            ++retries;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
            }
        }
        return status;
    }

    private OperationStatus readPrimaryAfterGet(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, int retries) throws DatabaseException {
        return this.readPrimaryAfterGet(this.primaryDb, key, pKey, data, lockMode, retries);
    }

    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, int retries) {
        SecondaryConfig conf = this.secondaryDb.getPrivateSecondaryConfig();
        boolean possibleIntegrityError = false;
        if (!conf.getImmutableSecondaryKey()) {
            if (conf.getKeyCreator() != null) {
                DatabaseEntry secKey = new DatabaseEntry();
                if (!conf.getKeyCreator().createSecondaryKey(this.secondaryDb, pKey, data, secKey) || !secKey.equals(key)) {
                    possibleIntegrityError = true;
                }
            } else if (conf.getMultiKeyCreator() != null) {
                HashSet<DatabaseEntry> results = new HashSet<DatabaseEntry>();
                conf.getMultiKeyCreator().createSecondaryKeys(this.secondaryDb, pKey, data, results);
                if (!results.contains(key)) {
                    possibleIntegrityError = true;
                }
            }
        }
        return possibleIntegrityError;
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }
}

