/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxnChain {
    private final Map<DatabaseId, DatabaseImpl> undoDatabases;
    private final EnvironmentImpl envImpl;
    private final Set<Long> remainingLockedNodes;
    private final LinkedList<RevertInfo> revertList;
    private VLSN lastValidVLSN;

    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, EnvironmentImpl envImpl) {
        this(lastLoggedLsn, txnId, matchpoint, null, envImpl);
    }

    /*
     * Exception decompiling
     */
    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, Map<DatabaseId, DatabaseImpl> undoDatabases, EnvironmentImpl envImpl) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DatabaseImpl getDatabaseImpl(DatabaseId dbId) {
        if (this.undoDatabases != null) {
            return this.undoDatabases.get(dbId);
        }
        return this.envImpl.getDbTree().getDb(dbId);
    }

    private void releaseDatabaseImpl(DatabaseImpl dbImpl) {
        if (this.undoDatabases == null) {
            this.envImpl.getDbTree().releaseDb(dbImpl);
        }
    }

    public Set<Long> getRemainingLockedNodes() {
        return this.remainingLockedNodes;
    }

    public RevertInfo pop() {
        return this.revertList.remove();
    }

    public VLSN getLastValidVLSN() {
        return this.lastValidVLSN;
    }

    public String toString() {
        return this.revertList.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareSlot
    implements Comparable<CompareSlot> {
        private final DatabaseImpl dbImpl;
        private final byte[] key;

        public CompareSlot(DatabaseImpl dbImpl, LNLogEntry undoEntry) {
            this(dbImpl, undoEntry.getKey());
        }

        private CompareSlot(DatabaseImpl dbImpl, byte[] key) {
            this.dbImpl = dbImpl;
            this.key = key;
        }

        @Override
        public int compareTo(CompareSlot other) {
            int dbCompare = this.dbImpl.getId().compareTo(other.dbImpl.getId());
            if (dbCompare != 0) {
                return dbCompare;
            }
            return Key.compareKeys(this.key, other.key, this.dbImpl.getKeyComparator());
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompareSlot)) {
                return false;
            }
            return this.compareTo((CompareSlot)other) == 0;
        }

        public int hashCode() {
            throw EnvironmentFailureException.unexpectedState("Hashing not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionCalculator {
        final long entryLsn;
        final long entryAbortLsn;
        final boolean entryAbortKnownDeleted;
        final LinkedList<Long> lsns;

        VersionCalculator(long entryLsn, long entryAbortLsn, boolean entryAbortKnownDeleted, LinkedList<Long> lsns) {
            this.entryLsn = entryLsn;
            this.entryAbortLsn = entryAbortLsn;
            this.entryAbortKnownDeleted = entryAbortKnownDeleted;
            this.lsns = lsns;
        }

        RevertInfo findPreviousVersion() {
            Long topVersion = this.lsns.remove();
            assert (this.entryLsn == topVersion) : "entryLsn= " + DbLsn.getNoFormatString(this.entryLsn) + "topLsn= " + DbLsn.getNoFormatString(topVersion);
            if (this.lsns.size() == 0) {
                return new RevertInfo(this.entryAbortLsn, this.entryAbortKnownDeleted);
            }
            return new RevertInfo(this.lsns.getFirst(), false);
        }
    }

    public static class RevertInfo {
        public long revertLsn;
        public boolean revertKnownDeleted;

        RevertInfo(long revertLsn, boolean revertKnownDeleted) {
            this.revertLsn = revertLsn;
            this.revertKnownDeleted = revertKnownDeleted;
        }

        public String toString() {
            return "revertLsn=" + DbLsn.getNoFormatString(this.revertLsn) + " revertKD=" + this.revertKnownDeleted;
        }
    }
}

