/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogReader;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.shaded.com.google.common.annotations.VisibleForTesting;
import com.spotify.docker.client.shaded.com.google.common.base.Charsets;
import com.spotify.docker.client.shaded.com.google.common.base.Throwables;
import com.spotify.docker.client.shaded.com.google.common.collect.AbstractIterator;
import com.spotify.docker.client.shaded.com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class DefaultLogStream
extends AbstractIterator<LogMessage>
implements LogStream {
    private final LogReader reader;

    private DefaultLogStream(InputStream stream) {
        this(new LogReader(stream));
    }

    @VisibleForTesting
    DefaultLogStream(LogReader reader) {
        this.reader = reader;
    }

    static DefaultLogStream create(InputStream stream) {
        return new DefaultLogStream(stream);
    }

    @Override
    protected LogMessage computeNext() {
        LogMessage message;
        try {
            message = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        if (message == null) {
            return (LogMessage)this.endOfData();
        }
        return message;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public String readFully() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            stringBuilder.append(Charsets.UTF_8.decode(((LogMessage)this.next()).content()));
        }
        return stringBuilder.toString();
    }

    @Override
    public void attach(OutputStream stdout, OutputStream stderr) throws IOException {
        this.attach(stdout, stderr, true);
    }

    @Override
    public void attach(OutputStream stdout, OutputStream stderr, boolean closeAtEof) throws IOException {
        try (Closer closer = Closer.create();){
            if (closeAtEof) {
                closer.register(stdout);
                closer.register(stderr);
            }
            while (this.hasNext()) {
                LogMessage message = (LogMessage)this.next();
                ByteBuffer content = message.content();
                switch (message.stream()) {
                    case STDOUT: {
                        DefaultLogStream.writeAndFlush(content, stdout);
                        break;
                    }
                    case STDERR: {
                        DefaultLogStream.writeAndFlush(content, stderr);
                        break;
                    }
                }
            }
        }
    }

    private static void writeAndFlush(ByteBuffer buffer, OutputStream outputStream) throws IOException {
        if (buffer.hasArray()) {
            outputStream.write(buffer.array(), buffer.position(), buffer.remaining());
        } else {
            while (buffer.hasRemaining()) {
                int size = Math.min(buffer.remaining(), 8192);
                byte[] chunk = new byte[size];
                buffer.get(chunk);
                outputStream.write(chunk);
            }
        }
        outputStream.flush();
    }
}

