/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.messages.Event;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;

public class EventReader
implements Closeable {
    private final ObjectMapper objectMapper;
    private final CloseableHttpResponse response;
    private JsonParser parser;

    public EventReader(CloseableHttpResponse response, ObjectMapper objectMapper) {
        this.response = response;
        this.objectMapper = objectMapper;
    }

    public Event nextMessage() throws IOException {
        if (this.parser == null) {
            this.parser = this.objectMapper.getFactory().createParser(this.response.getEntity().getContent());
        }
        if (this.parser.isClosed()) {
            return null;
        }
        if (this.parser.nextToken() == null) {
            return null;
        }
        return this.parser.readValueAs(Event.class);
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

