/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AttachedNetwork;
import com.spotify.docker.client.messages.AutoValue_NetworkSettings;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class NetworkSettings {
    @Nullable
    @JsonProperty(value="IPAddress")
    public abstract String ipAddress();

    @Nullable
    @JsonProperty(value="IPPrefixLen")
    public abstract Integer ipPrefixLen();

    @Nullable
    @JsonProperty(value="Gateway")
    public abstract String gateway();

    @Nullable
    @JsonProperty(value="Bridge")
    public abstract String bridge();

    @Nullable
    @JsonProperty(value="PortMapping")
    public abstract ImmutableMap<String, Map<String, String>> portMapping();

    @Nullable
    @JsonProperty(value="Ports")
    public abstract ImmutableMap<String, List<PortBinding>> ports();

    @Nullable
    @JsonProperty(value="MacAddress")
    public abstract String macAddress();

    @Nullable
    @JsonProperty(value="Networks")
    public abstract ImmutableMap<String, AttachedNetwork> networks();

    @Nullable
    @JsonProperty(value="EndpointID")
    public abstract String endpointId();

    @Nullable
    @JsonProperty(value="SandboxID")
    public abstract String sandboxId();

    @Nullable
    @JsonProperty(value="SandboxKey")
    public abstract String sandboxKey();

    @Nullable
    @JsonProperty(value="HairpinMode")
    public abstract Boolean hairpinMode();

    @Nullable
    @JsonProperty(value="LinkLocalIPv6Address")
    public abstract String linkLocalIPv6Address();

    @Nullable
    @JsonProperty(value="LinkLocalIPv6PrefixLen")
    public abstract Integer linkLocalIPv6PrefixLen();

    @Nullable
    @JsonProperty(value="GlobalIPv6Address")
    public abstract String globalIPv6Address();

    @Nullable
    @JsonProperty(value="GlobalIPv6PrefixLen")
    public abstract Integer globalIPv6PrefixLen();

    @Nullable
    @JsonProperty(value="IPv6Gateway")
    public abstract String ipv6Gateway();

    @JsonCreator
    static NetworkSettings create(@JsonProperty(value="IPAddress") String ipAddress, @JsonProperty(value="IPPrefixLen") Integer ipPrefixLen, @JsonProperty(value="Gateway") String gateway, @JsonProperty(value="Bridge") String bridge, @JsonProperty(value="PortMapping") Map<String, Map<String, String>> portMapping, @JsonProperty(value="Ports") Map<String, List<PortBinding>> ports, @JsonProperty(value="MacAddress") String macAddress, @JsonProperty(value="Networks") Map<String, AttachedNetwork> networks, @JsonProperty(value="EndpointID") String endpointId, @JsonProperty(value="SandboxID") String sandboxId, @JsonProperty(value="SandboxKey") String sandboxKey, @JsonProperty(value="HairpinMode") Boolean hairpinMode, @JsonProperty(value="LinkLocalIPv6Address") String linkLocalIPv6Address, @JsonProperty(value="LinkLocalIPv6PrefixLen") Integer linkLocalIPv6PrefixLen, @JsonProperty(value="GlobalIPv6Address") String globalIPv6Address, @JsonProperty(value="GlobalIPv6PrefixLen") Integer globalIPv6PrefixLen, @JsonProperty(value="IPv6Gateway") String ipv6Gateway) {
        ImmutableMap.Builder portsCopy = ImmutableMap.builder();
        if (ports != null) {
            for (Map.Entry<String, List<PortBinding>> entry : ports.entrySet()) {
                portsCopy.put((Object)entry.getKey(), entry.getValue() == null ? Collections.emptyList() : entry.getValue());
            }
        }
        return NetworkSettings.builder().ipAddress(ipAddress).ipPrefixLen(ipPrefixLen).gateway(gateway).bridge(bridge).portMapping(portMapping).ports((Map<String, List<PortBinding>>)portsCopy.build()).macAddress(macAddress).networks(networks).endpointId(endpointId).sandboxId(sandboxId).sandboxKey(sandboxKey).hairpinMode(hairpinMode).linkLocalIPv6Address(linkLocalIPv6Address).linkLocalIPv6PrefixLen(linkLocalIPv6PrefixLen).globalIPv6Address(globalIPv6Address).globalIPv6PrefixLen(globalIPv6PrefixLen).ipv6Gateway(ipv6Gateway).build();
    }

    private static Builder builder() {
        return new AutoValue_NetworkSettings.Builder();
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder ipAddress(String var1);

        abstract Builder ipPrefixLen(Integer var1);

        abstract Builder gateway(String var1);

        abstract Builder bridge(String var1);

        abstract Builder portMapping(Map<String, Map<String, String>> var1);

        abstract Builder ports(Map<String, List<PortBinding>> var1);

        abstract Builder macAddress(String var1);

        abstract Builder networks(Map<String, AttachedNetwork> var1);

        abstract Builder endpointId(String var1);

        abstract Builder sandboxId(String var1);

        abstract Builder sandboxKey(String var1);

        abstract Builder hairpinMode(Boolean var1);

        abstract Builder linkLocalIPv6Address(String var1);

        abstract Builder linkLocalIPv6PrefixLen(Integer var1);

        abstract Builder globalIPv6Address(String var1);

        abstract Builder globalIPv6PrefixLen(Integer var1);

        abstract Builder ipv6Gateway(String var1);

        abstract NetworkSettings build();
    }
}

