/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.internal.Internal;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.junit.rules.ExternalResource;

public final class MockWebServer
extends ExternalResource
implements Closeable {
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    private static final X509TrustManager UNTRUSTED_TRUST_MANAGER;
    private static final Logger logger;
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger requestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private int clientAuth = 0;
    private Dispatcher dispatcher = new QueueDispatcher();
    private int port = -1;
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    private List<Protocol> protocols = Util.immutableList((Object[])new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1});
    private boolean started;

    protected synchronized void before() {
        if (this.started) {
            return;
        }
        try {
            this.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        this.before();
        return this.port;
    }

    public String getHostName() {
        this.before();
        return this.inetSocketAddress.getAddress().getCanonicalHostName();
    }

    public Proxy toProxyAddress() {
        this.before();
        InetSocketAddress address = new InetSocketAddress(this.inetSocketAddress.getAddress().getCanonicalHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (this.executor != null) {
            throw new IllegalStateException("setServerSocketFactory() must be called before start()");
        }
        this.serverSocketFactory = serverSocketFactory;
    }

    public HttpUrl url(String path) {
        return new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
    }

    public void setBodyLimit(long maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void setProtocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        this.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    public void setProtocols(List<Protocol> protocols) {
        if ((protocols = Util.immutableList(protocols)).contains(Protocol.H2_PRIOR_KNOWLEDGE) && protocols.size() > 1) {
            throw new IllegalArgumentException("protocols containing h2_prior_knowledge cannot use other protocols: " + protocols);
        }
        if (!protocols.contains(Protocol.H2_PRIOR_KNOWLEDGE) && !protocols.contains(Protocol.HTTP_1_1)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
        }
        if (protocols.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = protocols;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public void noClientAuth() {
        this.clientAuth = 0;
    }

    public void requestClientAuth() {
        this.clientAuth = 1;
    }

    public void requireClientAuth() {
        this.clientAuth = 2;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public RecordedRequest takeRequest(long timeout, TimeUnit unit) throws InterruptedException {
        return this.requestQueue.poll(timeout, unit);
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    public void start() throws IOException {
        this.start(0);
    }

    public void start(int port) throws IOException {
        this.start(InetAddress.getByName("localhost"), port);
    }

    public void start(InetAddress inetAddress, int port) throws IOException {
        this.start(new InetSocketAddress(inetAddress, port));
    }

    private synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        if (this.started) {
            throw new IllegalStateException("start() already called");
        }
        this.started = true;
        this.executor = Executors.newCachedThreadPool(Util.threadFactory((String)"MockWebServer", (boolean)false));
        this.inetSocketAddress = inetSocketAddress;
        this.serverSocket = this.serverSocketFactory.createServerSocket();
        this.serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        this.serverSocket.bind(inetSocketAddress, 50);
        this.port = this.serverSocket.getLocalPort();
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{this.port}){

            protected void execute() {
                try {
                    logger.info(MockWebServer.this + " starting to accept connections");
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, MockWebServer.this + " failed unexpectedly", e);
                }
                Util.closeQuietly((ServerSocket)MockWebServer.this.serverSocket);
                Iterator s = MockWebServer.this.openClientSockets.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Socket)((Socket)s.next()));
                    s.remove();
                }
                s = MockWebServer.this.openConnections.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Closeable)((Closeable)s.next()));
                    s.remove();
                }
                MockWebServer.this.dispatcher.shutdown();
                MockWebServer.this.executor.shutdown();
            }

            private void acceptConnections() throws Exception {
                while (true) {
                    Socket socket;
                    try {
                        socket = MockWebServer.this.serverSocket.accept();
                    }
                    catch (SocketException e) {
                        logger.info(MockWebServer.this + " done accepting connections: " + e.getMessage());
                        return;
                    }
                    SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                        MockWebServer.this.dispatchBookkeepingRequest(0, socket);
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.add(socket);
                    MockWebServer.this.serveConnection(socket);
                }
            }
        });
    }

    public synchronized void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        if (this.serverSocket == null) {
            throw new IllegalStateException("shutdown() before start()");
        }
        this.serverSocket.close();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new IOException("Gave up waiting for executor to shut down");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    protected synchronized void after() {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "MockWebServer shutdown failed", e);
        }
    }

    private void serveConnection(final Socket raw) {
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{raw.getRemoteSocketAddress()}){
            int sequenceNumber;
            {
                super(arg0, arg1);
                this.sequenceNumber = 0;
            }

            protected void execute() {
                try {
                    this.processConnection();
                }
                catch (IOException e) {
                    logger.info(MockWebServer.this + " connection from " + raw.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, MockWebServer.this + " connection from " + raw.getInetAddress() + " crashed", e);
                }
            }

            public void processConnection() throws Exception {
                Socket socket;
                SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                Protocol protocol = Protocol.HTTP_1_1;
                if (MockWebServer.this.sslSocketFactory != null) {
                    if (MockWebServer.this.tunnelProxy) {
                        this.createTunnel();
                    }
                    if (socketPolicy == SocketPolicy.FAIL_HANDSHAKE) {
                        MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, raw);
                        MockWebServer.this.processHandshakeFailure(raw);
                        return;
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    SSLSocket sslSocket = (SSLSocket)socket;
                    sslSocket.setUseClientMode(false);
                    if (MockWebServer.this.clientAuth == 2) {
                        sslSocket.setNeedClientAuth(true);
                    } else if (MockWebServer.this.clientAuth == 1) {
                        sslSocket.setWantClientAuth(true);
                    }
                    MockWebServer.this.openClientSockets.add(socket);
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        Platform.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols);
                    }
                    sslSocket.startHandshake();
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        String protocolString = Platform.get().getSelectedProtocol(sslSocket);
                        protocol = protocolString != null ? Protocol.get((String)protocolString) : Protocol.HTTP_1_1;
                    }
                    MockWebServer.this.openClientSockets.remove(raw);
                } else if (MockWebServer.this.protocols.contains(Protocol.H2_PRIOR_KNOWLEDGE)) {
                    socket = raw;
                    protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                } else {
                    socket = raw;
                }
                if (socketPolicy == SocketPolicy.STALL_SOCKET_AT_START) {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, socket);
                    return;
                }
                if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    Http2SocketHandler http2SocketHandler = new Http2SocketHandler(socket, protocol);
                    Http2Connection connection = new Http2Connection.Builder(false).socket(socket).listener((Http2Connection.Listener)http2SocketHandler).build();
                    connection.start();
                    MockWebServer.this.openConnections.add(connection);
                    MockWebServer.this.openClientSockets.remove(socket);
                    return;
                }
                if (protocol != Protocol.HTTP_1_1) {
                    throw new AssertionError();
                }
                BufferedSource source = Okio.buffer((Source)Okio.source((Socket)socket));
                BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
                while (this.processOneRequest(socket, source, sink)) {
                }
                if (this.sequenceNumber == 0) {
                    logger.warning(MockWebServer.this + " connection from " + raw.getInetAddress() + " didn't make a request");
                }
                socket.close();
                MockWebServer.this.openClientSockets.remove(socket);
            }

            private void createTunnel() throws IOException, InterruptedException {
                SocketPolicy socketPolicy;
                BufferedSource source = Okio.buffer((Source)Okio.source((Socket)raw));
                BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)raw));
                do {
                    socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (this.processOneRequest(raw, source, sink)) continue;
                    throw new IllegalStateException("Tunnel without any CONNECT!");
                } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
            }

            private boolean processOneRequest(Socket socket, BufferedSource source, BufferedSink sink) throws IOException, InterruptedException {
                boolean responseWantsWebSockets;
                RecordedRequest request = MockWebServer.this.readRequest(socket, source, sink, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                    if (source.exhausted()) {
                        return false;
                    }
                    throw new ProtocolException("unexpected data");
                }
                boolean reuseSocket = true;
                boolean requestWantsWebSockets = "Upgrade".equalsIgnoreCase(request.getHeader("Connection")) && "websocket".equalsIgnoreCase(request.getHeader("Upgrade"));
                boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
                if (requestWantsWebSockets && responseWantsWebSockets) {
                    MockWebServer.this.handleWebSocketUpgrade(socket, source, sink, request, response);
                    reuseSocket = false;
                } else {
                    MockWebServer.this.writeHttpResponse(socket, sink, response);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response);
                }
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_INPUT_AT_END) {
                    socket.shutdownInput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_OUTPUT_AT_END) {
                    socket.shutdownOutput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_SERVER_AFTER_RESPONSE) {
                    MockWebServer.this.shutdown();
                }
                ++this.sequenceNumber;
                return reuseSocket;
            }
        });
    }

    private void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        try {
            socket.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket.close();
            return;
        }
    }

    private void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request = new RecordedRequest(null, null, null, -1L, null, sequenceNumber, socket);
        this.requestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    private RecordedRequest readRequest(Socket socket, BufferedSource source, BufferedSink sink, int sequenceNumber) throws IOException {
        String header;
        String request;
        try {
            request = source.readUtf8LineStrict();
        }
        catch (IOException streamIsClosed) {
            return null;
        }
        if (request.length() == 0) {
            return null;
        }
        Headers.Builder headers = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        while ((header = source.readUtf8LineStrict()).length() != 0) {
            Internal.instance.addLenient(headers, header);
            String lowercaseHeader = header.toLowerCase(Locale.US);
            if (contentLength == -1L && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Long.parseLong(header.substring(15).trim());
            }
            if (lowercaseHeader.startsWith("transfer-encoding:") && lowercaseHeader.substring(18).trim().equals("chunked")) {
                chunked = true;
            }
            if (!lowercaseHeader.startsWith("expect:") || !lowercaseHeader.substring(7).trim().equalsIgnoreCase("100-continue")) continue;
            expectContinue = true;
        }
        SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
        if (expectContinue && socketPolicy == SocketPolicy.EXPECT_CONTINUE || socketPolicy == SocketPolicy.CONTINUE_ALWAYS) {
            sink.writeUtf8("HTTP/1.1 100 Continue\r\n");
            sink.writeUtf8("Content-Length: 0\r\n");
            sink.writeUtf8("\r\n");
            sink.flush();
        }
        boolean hasBody = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        MockResponse policy = this.dispatcher.peek();
        if (contentLength != -1L) {
            hasBody = contentLength > 0L;
            this.throttledTransfer(policy, socket, source, Okio.buffer((Sink)requestBody), contentLength, true);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(source.readUtf8LineStrict().trim(), 16)) == 0) {
                    this.readEmptyLine(source);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.throttledTransfer(policy, socket, source, Okio.buffer((Sink)requestBody), chunkSize, true);
                this.readEmptyLine(source);
            }
        }
        String method = request.substring(0, request.indexOf(32));
        if (hasBody && !HttpMethod.permitsRequestBody((String)method)) {
            throw new IllegalArgumentException("Request must not have a body: " + request);
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.receivedByteCount, requestBody.buffer, sequenceNumber, socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWebSocketUpgrade(Socket socket, BufferedSource source, BufferedSink sink, RecordedRequest request, MockResponse response) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.acceptHeader((String)key));
        this.writeHttpResponse(socket, sink, response);
        String scheme = request.getTlsVersion() != null ? "https" : "http";
        String authority = request.getHeader("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + "/").headers(request.getHeaders()).build();
        Response fancyResponse = new Response.Builder().code(Integer.parseInt(response.getStatus().split(" ")[1])).message(response.getStatus().split(" ", 3)[2]).headers(response.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        final CountDownLatch connectionClose = new CountDownLatch(1);
        RealWebSocket.Streams streams = new RealWebSocket.Streams(false, source, sink){

            public void close() {
                connectionClose.countDown();
            }
        };
        RealWebSocket webSocket = new RealWebSocket(fancyRequest, response.getWebSocketListener(), (Random)new SecureRandom(), 0L);
        response.getWebSocketListener().onOpen((WebSocket)webSocket, fancyResponse);
        String name = "MockWebServer WebSocket " + request.getPath();
        webSocket.initReaderAndWriter(name, streams);
        try {
            webSocket.loopReader();
            try {
                connectionClose.await();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        catch (IOException e) {
            webSocket.failWebSocket((Exception)e, null);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    private void writeHttpResponse(Socket socket, BufferedSink sink, MockResponse response) throws IOException {
        this.sleepIfDelayed(response.getHeadersDelay(TimeUnit.MILLISECONDS));
        sink.writeUtf8(response.getStatus());
        sink.writeUtf8("\r\n");
        Headers headers = response.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            sink.writeUtf8(headers.name(i));
            sink.writeUtf8(": ");
            sink.writeUtf8(headers.value(i));
            sink.writeUtf8("\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
        Buffer body = response.getBody();
        if (body == null) {
            return;
        }
        this.sleepIfDelayed(response.getBodyDelay(TimeUnit.MILLISECONDS));
        this.throttledTransfer(response, socket, (BufferedSource)body, sink, body.size(), false);
    }

    private void sleepIfDelayed(long delayMs) {
        if (delayMs != 0L) {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void throttledTransfer(MockResponse policy, Socket socket, BufferedSource source, BufferedSink sink, long byteCount, boolean isRequest) throws IOException {
        boolean disconnectHalfway;
        if (byteCount == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = policy.getThrottleBytesPerPeriod();
        long periodDelayMs = policy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        long halfByteCount = byteCount / 2L;
        boolean bl = isRequest ? policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_REQUEST_BODY : (disconnectHalfway = policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        while (!socket.isClosed()) {
            int b = 0;
            while ((long)b < bytesPerPeriod) {
                long read;
                long toRead = Math.min(byteCount, bytesPerPeriod - (long)b);
                if (disconnectHalfway) {
                    toRead = Math.min(toRead, byteCount - halfByteCount);
                }
                if ((read = source.read(buffer, toRead)) == -1L) {
                    return;
                }
                sink.write(buffer, read);
                sink.flush();
                b = (int)((long)b + read);
                if (disconnectHalfway && (byteCount -= read) == halfByteCount) {
                    socket.close();
                    return;
                }
                if (byteCount != 0L) continue;
                return;
            }
            if (periodDelayMs == 0L) continue;
            try {
                Thread.sleep(periodDelayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void readEmptyLine(BufferedSource source) throws IOException {
        String line = source.readUtf8LineStrict();
        if (line.length() != 0) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.dispatcher = dispatcher;
    }

    public String toString() {
        return "MockWebServer[" + this.port + "]";
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    static {
        Internal.initializeInstanceForTests();
        UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                throw new AssertionError();
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                throw new AssertionError();
            }
        };
        logger = Logger.getLogger(MockWebServer.class.getName());
    }

    private class Http2SocketHandler
    extends Http2Connection.Listener {
        private final Socket socket;
        private final Protocol protocol;
        private final AtomicInteger sequenceNumber = new AtomicInteger();

        private Http2SocketHandler(Socket socket, Protocol protocol) {
            this.socket = socket;
            this.protocol = protocol;
        }

        public void onStream(Http2Stream stream) throws IOException {
            MockResponse response;
            MockResponse peekedResponse = MockWebServer.this.dispatcher.peek();
            if (peekedResponse.getSocketPolicy() == SocketPolicy.RESET_STREAM_AT_START) {
                try {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                    stream.close(ErrorCode.fromHttp2((int)peekedResponse.getHttp2ErrorCode()));
                    return;
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.requestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            try {
                response = MockWebServer.this.dispatcher.dispatch(request);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                this.socket.close();
                return;
            }
            this.writeResponse(stream, response);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol.toString());
            }
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                Http2Connection connection = stream.getConnection();
                connection.shutdown(ErrorCode.NO_ERROR);
            }
        }

        private RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = stream.takeHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            int size = streamHeaders.size();
            for (int i = 0; i < size; ++i) {
                String name = streamHeaders.name(i);
                String value = streamHeaders.value(i);
                if (name.equals(":method")) {
                    method = value;
                } else if (name.equals(":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add(name, value);
                } else {
                    throw new IllegalStateException();
                }
                if (!name.equals("expect") || !value.equalsIgnoreCase("100-continue")) continue;
                readBody = false;
            }
            Headers headers = httpHeaders.build();
            MockResponse peek = MockWebServer.this.dispatcher.peek();
            if (!readBody && peek.getSocketPolicy() == SocketPolicy.EXPECT_CONTINUE) {
                stream.writeHeaders(Collections.singletonList(new Header(Header.RESPONSE_STATUS, ByteString.encodeUtf8((String)"100 Continue"))), true);
                stream.getConnection().flush();
                readBody = true;
            }
            Buffer body = new Buffer();
            if (readBody) {
                String contentLengthString = headers.get("content-length");
                long byteCount = contentLengthString != null ? Long.parseLong(contentLengthString) : Long.MAX_VALUE;
                MockWebServer.this.throttledTransfer(peek, this.socket, Okio.buffer((Source)stream.getSource()), (BufferedSink)body, byteCount, true);
            }
            String requestLine = method + ' ' + path + " HTTP/1.1";
            List<Integer> chunkSizes = Collections.emptyList();
            return new RecordedRequest(requestLine, headers, chunkSizes, body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket);
        }

        private void writeResponse(Http2Stream stream, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            if (settings != null) {
                stream.getConnection().setSettings(settings);
            }
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            ArrayList<Header> http2Headers = new ArrayList<Header>();
            String[] statusParts = response.getStatus().split(" ", 3);
            if (statusParts.length < 2) {
                throw new AssertionError((Object)("Unexpected status: " + response.getStatus()));
            }
            http2Headers.add(new Header(Header.RESPONSE_STATUS, statusParts[1]));
            Headers headers = response.getHeaders();
            int size = headers.size();
            for (int i = 0; i < size; ++i) {
                http2Headers.add(new Header(headers.name(i), headers.value(i)));
            }
            MockWebServer.this.sleepIfDelayed(response.getHeadersDelay(TimeUnit.MILLISECONDS));
            Buffer body = response.getBody();
            boolean closeStreamAfterHeaders = body != null || !response.getPushPromises().isEmpty();
            stream.writeHeaders(http2Headers, closeStreamAfterHeaders);
            this.pushPromises(stream, response.getPushPromises());
            if (body != null) {
                BufferedSink sink = Okio.buffer((Sink)stream.getSink());
                MockWebServer.this.sleepIfDelayed(response.getBodyDelay(TimeUnit.MILLISECONDS));
                MockWebServer.this.throttledTransfer(response, this.socket, (BufferedSource)body, sink, body.size(), false);
                sink.close();
            } else if (closeStreamAfterHeaders) {
                stream.close(ErrorCode.NO_ERROR);
            }
        }

        private void pushPromises(Http2Stream stream, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                ArrayList<Header> pushedHeaders = new ArrayList<Header>();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.path()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.method()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.path()));
                Headers pushPromiseHeaders = pushPromise.headers();
                int size = pushPromiseHeaders.size();
                for (int i = 0; i < size; ++i) {
                    pushedHeaders.add(new Header(pushPromiseHeaders.name(i), pushPromiseHeaders.value(i)));
                }
                String requestLine = pushPromise.method() + ' ' + pushPromise.path() + " HTTP/1.1";
                List<Integer> chunkSizes = Collections.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.headers(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket));
                boolean hasBody = pushPromise.response().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, pushPromise.response());
            }
        }
    }

    private static class TruncatingBuffer
    implements Sink {
        private final Buffer buffer = new Buffer();
        private long remainingByteCount;
        private long receivedByteCount;

        TruncatingBuffer(long bodyLimit) {
            this.remainingByteCount = bodyLimit;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            long toSkip;
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        public void flush() throws IOException {
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() throws IOException {
        }
    }
}

