/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.http2.Settings;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.SocketPolicy;
import okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import okio.Buffer;

public final class MockResponse
implements Cloneable {
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";
    private String status;
    private Headers.Builder headers = new Headers.Builder();
    private Headers.Builder trailers = new Headers.Builder();
    private Buffer body;
    private long throttleBytesPerPeriod = Long.MAX_VALUE;
    private long throttlePeriodAmount = 1L;
    private TimeUnit throttlePeriodUnit = TimeUnit.SECONDS;
    private SocketPolicy socketPolicy = SocketPolicy.KEEP_OPEN;
    private int http2ErrorCode = -1;
    private long bodyDelayAmount = 0L;
    private TimeUnit bodyDelayUnit = TimeUnit.MILLISECONDS;
    private long headersDelayAmount = 0L;
    private TimeUnit headersDelayUnit = TimeUnit.MILLISECONDS;
    private List<PushPromise> promises = new ArrayList<PushPromise>();
    private Settings settings;
    private WebSocketListener webSocketListener;
    private DuplexResponseBody duplexResponseBody;

    public MockResponse() {
        this.setResponseCode(200);
        this.setHeader("Content-Length", 0);
    }

    public MockResponse clone() {
        try {
            MockResponse result = (MockResponse)super.clone();
            result.headers = this.headers.build().newBuilder();
            result.promises = new ArrayList<PushPromise>(this.promises);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public MockResponse setResponseCode(int code) {
        String reason = "Mock Response";
        if (code >= 100 && code < 200) {
            reason = "Informational";
        } else if (code >= 200 && code < 300) {
            reason = "OK";
        } else if (code >= 300 && code < 400) {
            reason = "Redirection";
        } else if (code >= 400 && code < 500) {
            reason = "Client Error";
        } else if (code >= 500 && code < 600) {
            reason = "Server Error";
        }
        return this.setStatus("HTTP/1.1 " + code + " " + reason);
    }

    public MockResponse setStatus(String status) {
        this.status = status;
        return this;
    }

    public Headers getHeaders() {
        return this.headers.build();
    }

    public Headers getTrailers() {
        return this.trailers.build();
    }

    public MockResponse clearHeaders() {
        this.headers = new Headers.Builder();
        return this;
    }

    public MockResponse addHeader(String header) {
        this.headers.add(header);
        return this;
    }

    public MockResponse addHeader(String name, Object value) {
        this.headers.add(name, String.valueOf(value));
        return this;
    }

    public MockResponse addHeaderLenient(String name, Object value) {
        Internal.instance.addLenient(this.headers, name, String.valueOf(value));
        return this;
    }

    public MockResponse setHeader(String name, Object value) {
        this.removeHeader(name);
        return this.addHeader(name, value);
    }

    public MockResponse setHeaders(Headers headers) {
        this.headers = headers.newBuilder();
        return this;
    }

    public MockResponse setTrailers(Headers trailers) {
        this.trailers = trailers.newBuilder();
        return this;
    }

    public MockResponse removeHeader(String name) {
        this.headers.removeAll(name);
        return this;
    }

    boolean isDuplex() {
        return this.duplexResponseBody != null;
    }

    DuplexResponseBody getDuplexResponseBody() {
        return this.duplexResponseBody;
    }

    public Buffer getBody() {
        return this.body != null ? this.body.clone() : null;
    }

    public MockResponse setBody(Buffer body) {
        this.setHeader("Content-Length", body.size());
        this.body = body.clone();
        return this;
    }

    public MockResponse setBody(String body) {
        return this.setBody(new Buffer().writeUtf8(body));
    }

    MockResponse setBody(DuplexResponseBody duplexResponseBody) {
        this.duplexResponseBody = duplexResponseBody;
        return this;
    }

    public MockResponse setChunkedBody(Buffer body, int maxChunkSize) {
        this.removeHeader("Content-Length");
        this.headers.add(CHUNKED_BODY_HEADER);
        Buffer bytesOut = new Buffer();
        while (!body.exhausted()) {
            long chunkSize = Math.min(body.size(), (long)maxChunkSize);
            bytesOut.writeHexadecimalUnsignedLong(chunkSize);
            bytesOut.writeUtf8("\r\n");
            bytesOut.write(body, chunkSize);
            bytesOut.writeUtf8("\r\n");
        }
        bytesOut.writeUtf8("0\r\n");
        this.body = bytesOut;
        return this;
    }

    public MockResponse setChunkedBody(String body, int maxChunkSize) {
        return this.setChunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
    }

    public SocketPolicy getSocketPolicy() {
        return this.socketPolicy;
    }

    public MockResponse setSocketPolicy(SocketPolicy socketPolicy) {
        this.socketPolicy = socketPolicy;
        return this;
    }

    public int getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    public MockResponse setHttp2ErrorCode(int http2ErrorCode) {
        this.http2ErrorCode = http2ErrorCode;
        return this;
    }

    public MockResponse throttleBody(long bytesPerPeriod, long period, TimeUnit unit) {
        this.throttleBytesPerPeriod = bytesPerPeriod;
        this.throttlePeriodAmount = period;
        this.throttlePeriodUnit = unit;
        return this;
    }

    public long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    public long getThrottlePeriod(TimeUnit unit) {
        return unit.convert(this.throttlePeriodAmount, this.throttlePeriodUnit);
    }

    public MockResponse setBodyDelay(long delay, TimeUnit unit) {
        this.bodyDelayAmount = delay;
        this.bodyDelayUnit = unit;
        return this;
    }

    public long getBodyDelay(TimeUnit unit) {
        return unit.convert(this.bodyDelayAmount, this.bodyDelayUnit);
    }

    public MockResponse setHeadersDelay(long delay, TimeUnit unit) {
        this.headersDelayAmount = delay;
        this.headersDelayUnit = unit;
        return this;
    }

    public long getHeadersDelay(TimeUnit unit) {
        return unit.convert(this.headersDelayAmount, this.headersDelayUnit);
    }

    public MockResponse withPush(PushPromise promise) {
        this.promises.add(promise);
        return this;
    }

    public List<PushPromise> getPushPromises() {
        return this.promises;
    }

    public MockResponse withSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MockResponse withWebSocketUpgrade(WebSocketListener listener) {
        this.setStatus("HTTP/1.1 101 Switching Protocols");
        this.setHeader("Connection", "Upgrade");
        this.setHeader("Upgrade", "websocket");
        this.body = null;
        this.webSocketListener = listener;
        return this;
    }

    public WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    public String toString() {
        return this.status;
    }
}

