/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountOptions;
import com.stormpath.sdk.account.CreateAccountRequestBuilder;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.query.EqualsExpressionFactory;
import com.stormpath.sdk.query.StringExpressionFactory;
import java.lang.reflect.Constructor;

public final class Accounts {
    private static final Class<CreateAccountRequestBuilder> BUILDER_CLASS = Classes.forName("com.stormpath.sdk.impl.account.DefaultCreateAccountRequestBuilder");

    public static AccountOptions<AccountOptions> options() {
        return (AccountOptions)Classes.newInstance("com.stormpath.sdk.impl.account.DefaultAccountOptions");
    }

    public static AccountCriteria criteria() {
        return (AccountCriteria)Classes.newInstance("com.stormpath.sdk.impl.account.DefaultAccountCriteria");
    }

    public static AccountCriteria where(Criterion criterion) {
        return (AccountCriteria)Accounts.criteria().add(criterion);
    }

    public static StringExpressionFactory email() {
        return Accounts.newStringExpressionFactory("email");
    }

    public static StringExpressionFactory username() {
        return Accounts.newStringExpressionFactory("username");
    }

    public static StringExpressionFactory givenName() {
        return Accounts.newStringExpressionFactory("givenName");
    }

    public static StringExpressionFactory middleName() {
        return Accounts.newStringExpressionFactory("middleName");
    }

    public static StringExpressionFactory surname() {
        return Accounts.newStringExpressionFactory("surname");
    }

    public static EqualsExpressionFactory status() {
        return Accounts.newEqualsExpressionFactory("status");
    }

    public static CreateAccountRequestBuilder newCreateRequestFor(Account account) {
        Constructor<CreateAccountRequestBuilder> ctor = Classes.getConstructor(BUILDER_CLASS, Account.class);
        return Classes.instantiate(ctor, account);
    }

    private static StringExpressionFactory newStringExpressionFactory(String propName) {
        String FQCN = "com.stormpath.sdk.impl.query.DefaultStringExpressionFactory";
        return (StringExpressionFactory)Classes.newInstance("com.stormpath.sdk.impl.query.DefaultStringExpressionFactory", propName);
    }

    private static EqualsExpressionFactory newEqualsExpressionFactory(String propName) {
        String FQCN = "com.stormpath.sdk.impl.query.DefaultEqualsExpressionFactory";
        return (EqualsExpressionFactory)Classes.newInstance("com.stormpath.sdk.impl.query.DefaultEqualsExpressionFactory", propName);
    }
}

