/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.authc;

import com.stormpath.sdk.authc.AuthenticationRequest;

public class UsernamePasswordRequest
implements AuthenticationRequest<String, char[]> {
    private String username;
    private char[] password;
    private String host;

    public UsernamePasswordRequest(String username, String password) {
        this(username, password, null);
    }

    public UsernamePasswordRequest(String username, char[] password) {
        this(username, password, null);
    }

    public UsernamePasswordRequest(String username, String password, String host) {
        this(username, password != null ? password.toCharArray() : "".toCharArray(), host);
    }

    public UsernamePasswordRequest(String username, char[] password, String host) {
        this.username = username;
        this.password = password;
        this.host = host;
    }

    @Override
    public String getPrincipals() {
        return this.username;
    }

    @Override
    public char[] getCredentials() {
        return this.password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void clear() {
        this.username = null;
        this.host = null;
        char[] password = this.password;
        this.password = null;
        if (password != null) {
            for (int i = 0; i < password.length; ++i) {
                password[i] = '\u0000';
            }
        }
    }
}

