/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.resource;

import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.lang.Assert;

public class ResourceException
extends RuntimeException
implements Error {
    private final Error error;

    private static String buildExceptionMessage(Error error) {
        Assert.notNull(error, "Error argument cannot be null.");
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP ").append(error.getStatus()).append(", Stormpath ").append(error.getCode()).append(" (").append(error.getMoreInfo()).append("): ").append(error.getDeveloperMessage());
        return sb.toString();
    }

    public ResourceException(Error error) {
        super(ResourceException.buildExceptionMessage(error));
        this.error = error;
    }

    @Override
    public int getStatus() {
        return this.error.getStatus();
    }

    @Override
    public int getCode() {
        return this.error.getCode();
    }

    @Override
    public String getDeveloperMessage() {
        return this.error.getDeveloperMessage();
    }

    @Override
    public String getMoreInfo() {
        return this.error.getMoreInfo();
    }
}

